/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.weka.evaluator.AbstractInstanceEvaluator;
import adams.data.weka.evaluator.IntervalEstimatorBased;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.source.SequenceSource;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceDumper;
import adams.flow.transformer.WekaInstanceEvaluator;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.functions.GaussianProcesses;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.RBFKernel;

public class WekaInstanceEvaluatorTest
extends AbstractFlowTest {
    public WekaInstanceEvaluatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfsTrain = new SingleFileSupplier();
        sfsTrain.setFile((PlaceholderFile)new TmpFile("bolts.arff"));
        WekaFileReader frTrain = new WekaFileReader();
        WekaClassSelector csTrain = new WekaClassSelector();
        SequenceSource seqs = new SequenceSource();
        seqs.setName("train");
        seqs.setActors(new AbstractActor[]{sfsTrain, frTrain, csTrain});
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{seqs});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("bolts.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setIncremental(true);
        WekaClassSelector cs = new WekaClassSelector();
        GaussianProcesses gp = new GaussianProcesses();
        gp.setKernel((Kernel)new RBFKernel());
        gp.setNoise(0.01);
        IntervalEstimatorBased ieb = new IntervalEstimatorBased();
        ieb.setClassifier((Classifier)gp);
        WekaInstanceEvaluator eval = new WekaInstanceEvaluator();
        eval.setEvaluator((AbstractInstanceEvaluator)ieb);
        eval.setInstancesActor(new GlobalActorReference("train"));
        WekaInstanceDumper id = new WekaInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, eval, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(WekaInstanceEvaluatorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstanceEvaluatorTest.runTest((Test)WekaInstanceEvaluatorTest.suite());
    }
}

