/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instance;

import adams.data.container.DataContainerUtils;
import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.instance.InstancePointComparator;
import java.util.Collections;
import java.util.List;

public class InstanceUtils
extends DataContainerUtils {
    protected static InstancePointComparator m_Comparator = new InstancePointComparator(false, true);

    public static InstancePointComparator getComparator() {
        return m_Comparator;
    }

    public static int findX(List<InstancePoint> points, InstancePoint p) {
        int result = Collections.binarySearch(points, p, m_Comparator);
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    public static int findX(List<InstancePoint> points, int x) {
        return InstanceUtils.findX(points, new InstancePoint(x, 0.0));
    }

    public static int findClosestX(List<InstancePoint> points, int x) {
        int result = -1;
        if (points.size() == 0) {
            return result;
        }
        int index = Collections.binarySearch(points, new InstancePoint(x, 0.0), m_Comparator);
        if (index < 0) {
            if ((index = -index) >= points.size()) {
                index = points.size() - 1;
            }
            result = index;
            double dist = Math.abs((double)x - points.get(index).getX().doubleValue());
            for (int i = index - 2; i <= index + 2; ++i) {
                InstancePoint currPoint;
                double currDist;
                if (i < 0 || i >= points.size() || !((currDist = Math.abs((double)x - (currPoint = points.get(i)).getX().doubleValue())) < dist)) continue;
                dist = currDist;
                result = i;
            }
        } else {
            result = index;
        }
        return result;
    }

    public static int[] findEnclosingXs(List<InstancePoint> points, int x) {
        int[] result = new int[]{-1, -1};
        int index = InstanceUtils.findClosestX(points, x);
        if (index > -1) {
            if (points.get(index).getX().doubleValue() <= (double)x) {
                result[0] = index;
                if (index < points.size() - 1) {
                    result[1] = index + 1;
                }
            } else if (points.get(index).getX().doubleValue() > (double)x) {
                result[1] = index;
                if (index > 0) {
                    result[0] = index - 1;
                }
            }
        }
        return result;
    }

    public static double[] toDoubleArray(Instance c) {
        return InstanceUtils.toDoubleArray(c.toList());
    }

    public static double[] toDoubleArray(List<InstancePoint> data) {
        double[] result = new double[data.size()];
        int i = 0;
        for (InstancePoint gcp : data) {
            result[i++] = new Double(gcp.getY());
        }
        return result;
    }
}

