/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package weka.classifiers.meta;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.AbstractAdamsClassifierTest;
import weka.classifiers.Classifier;
import weka.classifiers.meta.SubsetEnsemble;
import weka.test.AdamsTestHelper;

/**
 * Tests SubsetEnsemble. Run from the command line with:<p/>
 * java weka.classifiers.meta.SubsetEnsembleTest
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4521 $
 */
public class SubsetEnsembleTest
  extends AbstractAdamsClassifierTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public SubsetEnsembleTest(String name) {
    super(name);
  }

  /**
   * Creates a default SubsetEnsemble.
   *
   * @return		the configured classifier
   */
  public Classifier getClassifier() {
    SubsetEnsemble	result;

    result = new SubsetEnsemble();
    result.setClassifier(new weka.classifiers.trees.J48());

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(SubsetEnsembleTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    AdamsTestHelper.setRegressionRoot();
    TestRunner.run(suite());
  }
}
