/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.provenance.Provenance;
import adams.flow.sink.ProvenanceDisplay;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class ProvenanceDisplayTest
extends AbstractFlowTest {
    protected boolean m_ProvenanceEnabled;

    public ProvenanceDisplayTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        this.m_ProvenanceEnabled = Provenance.getSingleton().isEnabled();
        Provenance.getSingleton().setEnabled(true);
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        Provenance.getSingleton().setEnabled(this.m_ProvenanceEnabled);
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifier cls = new WekaClassifier();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{cls});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaFilter wf = new WekaFilter();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new GlobalActorReference("cls"));
        ProvenanceDisplay pd = new ProvenanceDisplay();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, wf, cv, pd});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(ProvenanceDisplayTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ProvenanceDisplayTest.runTest((Test)ProvenanceDisplayTest.suite());
    }
}

