/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.Screenshot;
import adams.flow.sink.WekaCostCurve;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaFileReader;
import adams.gui.print.JComponentWriter;
import adams.gui.print.PNGWriter;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class ScreenshotTest
extends AbstractFlowTest {
    public ScreenshotTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("screenshot1.png");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("screenshot1.png");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifier cls = new WekaClassifier();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{cls});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new GlobalActorReference("cls"));
        WekaCostCurve cc = new WekaCostCurve();
        PNGWriter writer = new PNGWriter();
        Screenshot shot = new Screenshot();
        shot.setWriter((JComponentWriter)writer);
        shot.setOutput((PlaceholderFile)new TmpFile());
        shot.setPanelProvider((DisplayPanelProvider)cc);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, cv, shot});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(ScreenshotTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ScreenshotTest.runTest((Test)ScreenshotTest.suite());
    }
}

