/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.MultiFileSupplier;
import adams.flow.transformer.AnyToCommandline;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifierOptimizer;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.meta.GridSearch;
import weka.core.Utils;

public class WekaClassifierOptimizerTest
extends AbstractFlowTest {
    public WekaClassifierOptimizerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        MultiFileSupplier mfs = new MultiFileSupplier();
        mfs.setFiles((PlaceholderFile[])new TmpFile[]{new TmpFile("vote.arff"), new TmpFile("labor.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaClassifierOptimizer co = new WekaClassifierOptimizer();
        GridSearch gs = new GridSearch();
        try {
            gs.setOptions(Utils.splitOptions((String)"-E ACC -y-property classifier.minNumObj -y-min 2.0 -y-max 5.0 -y-step 1.0 -y-base 10.0 -y-expression I -filter weka.filters.AllFilter -x-property classifier.confidenceFactor -x-min 0.1 -x-max 0.5 -x-step 0.05 -x-base 10.0 -x-expression I -sample-size 100.0 -traversal COLUMN-WISE -log-file /home/fracpete/development/projects/adams -num-slots 1 -S 1 -W weka.classifiers.trees.J48 -- -C 0.25 -M 2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            WekaClassifierOptimizerTest.fail((String)("Failed to set options for optimizer: " + e));
        }
        co.setOptimizer((Classifier)gs);
        AnyToCommandline a2c = new AnyToCommandline();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{mfs, fr, cs, co, a2c, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaClassifierOptimizerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClassifierOptimizerTest.runTest((Test)WekaClassifierOptimizerTest.suite());
    }
}

