/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaPredictionsToInstances;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class WekaPredictionsToInstancesTest
extends AbstractFlowTest {
    public WekaPredictionsToInstancesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifier cls = new WekaClassifier();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{cls});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new GlobalActorReference("cls"));
        WekaPredictionsToInstances p2i = new WekaPredictionsToInstances();
        WekaFileWriter fw = new WekaFileWriter();
        fw.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.arff"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, cv, p2i, fw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(WekaPredictionsToInstancesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaPredictionsToInstancesTest.runTest((Test)WekaPredictionsToInstancesTest.suite());
    }
}

