/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClusterer;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.wekaclusterer.AbstractClustererPostProcessor;
import adams.flow.transformer.wekaclusterer.PassThrough;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class PassThroughTest
extends AbstractFlowTest {
    public PassThroughTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testImage() {
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(PassThroughTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[6];
            SingleFileSupplier tmp2 = new SingleFileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("file");
            tmp2.setFile((PlaceholderFile)new TmpFile("bolts.arff"));
            tmp1[0] = tmp2;
            WekaFileReader tmp4 = new WekaFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("customLoader");
            ArffLoader tmp6 = new ArffLoader();
            tmp4.setCustomLoader((AbstractFileLoader)tmp6);
            tmp1[1] = tmp4;
            WekaFilter tmp7 = new WekaFilter();
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("filter");
            Remove tmp9 = new Remove();
            tmp9.setOptions(OptionUtils.splitOptions((String)"\"\" \"\" \"\""));
            tmp7.setFilter((Filter)tmp9);
            tmp1[2] = tmp7;
            WekaClusterer tmp10 = new WekaClusterer();
            argOption = (AbstractArgumentOption)tmp10.getOptionManager().findByProperty("clusterer");
            SimpleKMeans tmp12 = new SimpleKMeans();
            tmp12.setOptions(OptionUtils.splitOptions((String)"-N 2 -A \"weka.core.EuclideanDistance -R first-last\" -I 500 -S 10"));
            tmp10.setClusterer((Clusterer)tmp12);
            argOption = (AbstractArgumentOption)tmp10.getOptionManager().findByProperty("postProcessor");
            PassThrough tmp14 = new PassThrough();
            tmp10.setPostProcessor((AbstractClustererPostProcessor)tmp14);
            tmp1[3] = tmp10;
            ContainerValuePicker tmp15 = new ContainerValuePicker();
            argOption = (AbstractArgumentOption)tmp15.getOptionManager().findByProperty("valueName");
            tmp15.setValueName((String)argOption.valueOf("Clustered dataset"));
            tmp15.setSwitchOutputs(true);
            tmp1[4] = tmp15;
            DumpFile tmp17 = new DumpFile();
            tmp17.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
            tmp1[5] = tmp17;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            PassThroughTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        PassThroughTest.runTest((Test)PassThroughTest.suite());
    }
}

