/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveWithZeroes;
import weka.test.AdamsTestHelper;

public class RemoveWithZeroesTest
extends AbstractAdamsFilterTest {
    public RemoveWithZeroesTest(String name) {
        super(name);
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier((Classifier)new J48());
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(3);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return new RemoveWithZeroes();
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveWithZeroesTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            RemoveWithZeroesTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveWithZeroesTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        RemoveWithZeroesTest.assertEquals((int)result.numAttributes(), (int)this.m_Instances.numAttributes());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(RemoveWithZeroesTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)RemoveWithZeroesTest.suite());
    }
}

