/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.AbstractDistanceBasedHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;

public class InstancePointHitDetector
extends AbstractDistanceBasedHitDetector {
    private static final long serialVersionUID = 3397379783536355060L;
    protected InstancePanel m_Owner;

    public InstancePointHitDetector(InstancePanel owner) {
        this.m_Owner = owner;
    }

    public InstancePanel getOwner() {
        return this.m_Owner;
    }

    protected int[] findEnclosingAttributeIndices(Instance inst, double x) {
        int[] result = new int[]{-1, -1};
        if (Math.floor(x) == x) {
            result[0] = (int)x;
        } else {
            result[0] = (int)Math.floor(x);
            result[1] = (int)Math.ceil(x);
        }
        for (int i = 0; i < 2; ++i) {
            if (result[i] >= 0 && result[i] < inst.size()) continue;
            result[i] = -1;
        }
        return result;
    }

    protected int findClosestAttributeIndex(Instance inst, double x) {
        int result = (int)Math.round(x);
        if (result < 0) {
            result = 0;
        } else if (result > inst.size() - 1) {
            result = inst.size() - 1;
        }
        return result;
    }

    protected InstancePoint findInstancePoint(Instance inst, int index) {
        InstancePoint result = null;
        List list = inst.toList();
        for (int i = 0; i < list.size(); ++i) {
            if (((InstancePoint)((Object)list.get(i))).getX() != index) continue;
            result = (InstancePoint)((Object)list.get(i));
            break;
        }
        return result;
    }

    protected Object isHit(MouseEvent e) {
        Vector<InstancePoint> result = new Vector<InstancePoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        for (int i = 0; i < ((InstanceContainerManager)this.m_Owner.getContainerManager()).count(); ++i) {
            InstancePoint ip;
            if (!((InstanceContainer)((InstanceContainerManager)this.m_Owner.getContainerManager()).get(i)).isVisible()) continue;
            Instance inst = ((InstanceContainer)((InstanceContainerManager)this.m_Owner.getContainerManager()).get(i)).getData();
            int[] indices = this.findEnclosingAttributeIndices(inst, x);
            if (indices[0] < 0 || indices[1] < 0) {
                int index = this.findClosestAttributeIndex(inst, x);
                ip = this.findInstancePoint(inst, index);
                if (ip == null) {
                    this.getDebugging().println("Failed to determine instance point for attribute index #" + index + ": " + (Object)((Object)inst));
                    continue;
                }
                double diffX = (double)ip.getX().intValue() - x;
                int diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
                this.getDebugging().println("diff timestamp=" + diffPixel);
                if (diffPixel > this.m_MinimumPixelDifference) continue;
                double diffY = ip.getY() - y;
                diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
                this.getDebugging().println("diff abundance=" + diffPixel);
                if (diffPixel > this.m_MinimumPixelDifference) continue;
                result.add(ip);
                continue;
            }
            ip = this.findInstancePoint(inst, indices[0]);
            if (ip == null) {
                this.getDebugging().println("Failed to determine instance point for attribute index #" + indices[0] + ": " + (Object)((Object)inst));
                continue;
            }
            InstancePoint ip2 = this.findInstancePoint(inst, indices[1]);
            if (ip2 == null) {
                this.getDebugging().println("Failed to determine instance point for attribute index #" + indices[1] + ": " + (Object)((Object)inst));
                continue;
            }
            double dist = this.distance(new Point2D.Double(axisBottom.valueToPos((double)ip.getX().intValue()), axisLeft.valueToPos(ip.getY().doubleValue())), new Point2D.Double(axisBottom.valueToPos((double)ip2.getX().intValue()), axisLeft.valueToPos(ip2.getY().doubleValue())), new Point2D.Double(e.getX(), e.getY()));
            this.getDebugging().println("dist line=" + dist);
            if (dist > (double)this.m_MinimumPixelDifference) continue;
            result.add(ip);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    protected Object processHit(MouseEvent e, Object hit) {
        Vector hits = (Vector)hit;
        String result = "";
        for (int i = 0; i < hits.size(); ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            Instance chr = (Instance)((InstancePoint)((Object)hits.get(i))).getParent();
            InstanceContainer cont = ((InstanceContainerManager)this.m_Owner.getContainerManager()).newContainer((Comparable)((Object)chr));
            result = result + hits.get(i) + " (" + cont.getDisplayID() + ")";
        }
        return result;
    }

    public void cleanUp() {
        this.m_Owner = null;
        super.cleanUp();
    }
}

