/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.BinarySparseInstance;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class SetMissingValue
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 5695593189966243444L;
    protected Range m_AttributeRange = new Range("last");

    public String globalInfo() {
        return "Attribute values in the given range are set to missing values.\nNB: The class attribute is not excluded from this process.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe range of attributes to set to missing values.\n\t(default: last)", "R", 1, "-R <range specification>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAttributeRange(tmpStr);
        } else {
            this.setAttributeRange("last");
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add("" + this.getAttributeRange());
        return result.toArray(new String[result.size()]);
    }

    public String attributeRangeTipText() {
        return "The range of attributes to set to missing values.";
    }

    public void setAttributeRange(String value) {
        this.m_AttributeRange.setRanges(value);
    }

    public String getAttributeRange() {
        return this.m_AttributeRange.getRanges();
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeRange.setUpper(inputFormat.numAttributes() - 1);
        return new Instances(inputFormat, 0);
    }

    protected Instance process(Instance instance) throws Exception {
        double[] values = (double[])instance.toDoubleArray().clone();
        for (int i = 0; i < values.length; ++i) {
            if (!this.m_AttributeRange.isInRange(i)) continue;
            values[i] = Utils.missingValue();
        }
        Object result = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), values) : (instance instanceof BinarySparseInstance ? new BinarySparseInstance(instance.weight(), values) : new DenseInstance(instance.weight(), values));
        result.setDataset(this.getOutputFormat());
        this.copyValues((Instance)result, false, instance.dataset(), this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        SetMissingValue.runFilter((Filter)new SetMissingValue(), (String[])args);
    }
}

