/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.predictions;

import adams.data.weka.predictions.AbstractErrorScaler;
import java.util.ArrayList;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;

public class RelativeNumericErrorScaler
extends AbstractErrorScaler {
    private static final long serialVersionUID = -8616657706467047751L;
    protected int m_MaxSize;

    public String globalInfo() {
        return "Scales the errors for numeric class attributes.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max", "maxSize", (Object)20, (Number)1, null);
    }

    public void setMaxSize(int value) {
        this.m_MaxSize = value;
        this.reset();
    }

    public int getMaxSize() {
        return this.m_MaxSize;
    }

    public String maxSizeTipText() {
        return "The maximum size of the errors after scaling.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        return result;
    }

    public ArrayList scale(ArrayList data) {
        double err;
        Double errd;
        int i;
        ArrayList<Integer> result = new ArrayList<Integer>();
        double maxErr = Double.NEGATIVE_INFINITY;
        double minErr = Double.POSITIVE_INFINITY;
        for (i = 0; i < data.size(); ++i) {
            errd = (Double)data.get(i);
            if (errd == null) continue;
            err = Math.abs(errd);
            if (err < minErr) {
                minErr = err;
            }
            if (!(err > maxErr)) continue;
            maxErr = err;
        }
        for (i = 0; i < data.size(); ++i) {
            errd = (Double)data.get(i);
            if (errd != null) {
                err = Math.abs(errd);
                if (maxErr - minErr > 0.0) {
                    double temp = (err - minErr) / (maxErr - minErr) * (double)this.m_MaxSize;
                    result.add(new Integer((int)temp));
                    continue;
                }
                result.add(new Integer(1));
                continue;
            }
            result.add(new Integer(1));
        }
        return result;
    }
}

