/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WekaFilterTest
extends AbstractFlowTest {
    public WekaFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        Remove rm = new Remove();
        rm.setAttributeIndices("1-10");
        WekaFilter wf = new WekaFilter();
        wf.setFilter((Filter)rm);
        WekaFileWriter fw = new WekaFileWriter();
        fw.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, wf, fw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(WekaFilterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaFilterTest.runTest((Test)WekaFilterTest.suite());
    }
}

