/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SequencePlotter;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceStreamPlotGenerator;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaInstanceStreamPlotGeneratorTest
extends AbstractFlowTest {
    public WekaInstanceStreamPlotGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("bolts.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setIncremental(true);
        WekaInstanceStreamPlotGenerator ispg = new WekaInstanceStreamPlotGenerator();
        ispg.setAttributes("1-7");
        SequencePlotter sp = new SequencePlotter();
        sp.setLimit(30);
        sp.setPaintlet((AbstractXYSequencePaintlet)new XYSequenceLinePaintlet());
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, ispg, sp});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(WekaInstanceStreamPlotGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstanceStreamPlotGeneratorTest.runTest((Test)WekaInstanceStreamPlotGeneratorTest.suite());
    }
}

