/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SetMissingValue;
import weka.test.AdamsTestHelper;

public class SetMissingValueTest
extends AbstractAdamsFilterTest {
    public SetMissingValueTest(String name) {
        super(name);
    }

    public Filter getFilter() {
        return this.getFilter("last");
    }

    public Filter getFilter(String range) {
        SetMissingValue result = new SetMissingValue();
        result.setAttributeRange(range);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SetMissingValueTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            SetMissingValueTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SetMissingValueTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        SetMissingValueTest.assertEquals((int)icopy.numAttributes(), (int)result.numAttributes());
        SetMissingValueTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
        SetMissingValue filter = (SetMissingValue)this.m_Filter;
        Range range = new Range(filter.getAttributeRange());
        range.setUpper(icopy.numAttributes() - 1);
        int[] indices = range.getSelection();
        for (int n = 0; n < result.numInstances(); ++n) {
            for (int i = 0; i < indices.length; ++i) {
                SetMissingValueTest.assertTrue((String)("Value at " + (n + 1) + "/" + (indices[i] + 1) + " not set to missing!"), (boolean)Utils.isMissingValue((double)result.instance(n).value(indices[i])));
            }
        }
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testFirst() {
        this.m_Filter = this.getFilter("first");
        this.testBuffered();
        this.performTest();
    }

    public void testSecond() {
        this.m_Filter = this.getFilter("2");
        this.testBuffered();
        this.performTest();
    }

    public void testAll() {
        this.m_Filter = this.getFilter("first-last");
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(SetMissingValueTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)SetMissingValueTest.suite());
    }
}

