/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import adams.core.option.OptionUtils;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.MathematicalExpression;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PropertyPath;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.ListParameter;
import weka.core.setupgenerator.MathParameter;
import weka.core.setupgenerator.Point;
import weka.core.setupgenerator.Space;
import weka.core.setupgenerator.SpaceDimension;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupGenerator
implements Serializable,
OptionHandler {
    private static final long serialVersionUID = 7683008589774888142L;
    public static final int TYPE_FUNCTION = 0;
    public static final int TYPE_LIST = 1;
    public static final Tag[] TAGS_TYPE = new Tag[]{new Tag(0, "func", "Mathematical function"), new Tag(1, "list", "Comma-separated list of values")};
    protected Serializable m_BaseObject = null;
    protected AbstractParameter[] m_Parameters = new AbstractParameter[0];
    protected boolean m_Initialized;
    protected Space m_Space;

    public SetupGenerator() {
        this.reset();
    }

    public String globalInfo() {
        return "Generates different setups of objects (e.g., classifiers or filters) based on parameter settings. The parameter settings can be either based on mathematical functions; therefore numeric) or chosen from lists (for string values, SelectedTags or classnames (with optional parameters).";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe object to generate the setups for, e.g., a classifier.\n\tOptions for the object (in case it is an OptionHandler)\n\thave to be provided after the '--' meta-option.", "W", 1, "-W \"<classname>\""));
        result.addElement(new Option("\tA parameter setup for generating the setups.\n\tCan be supplied multiple times.\n\t(default: " + AbstractParameter.class.getName() + ")", "search", 1, "-search <classname options>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to search parameter class '" + MathParameter.class.getName() + "' ('-search'):"));
        Enumeration en = new MathParameter().listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("", "", 0, "\nOptions specific to search parameter class '" + ListParameter.class.getName() + "' ('-search'):"));
        en = new ListParameter().listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        result.add("-W");
        result.add("" + this.getBaseObject().getClass().getName());
        for (i = 0; i < this.m_Parameters.length; ++i) {
            result.add("-search");
            String tmpStr = this.m_Parameters[i].getClass().getName() + " " + Utils.joinOptions((String[])this.m_Parameters[i].getOptions());
            result.add(tmpStr);
        }
        if (this.getBaseObject() instanceof OptionHandler) {
            result.add("--");
            String[] options = ((OptionHandler)this.getBaseObject()).getOptions();
            for (i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'W', (String[])options);
        if (tmpStr.length() == 0) {
            throw new IllegalArgumentException("No base object provided!");
        }
        Serializable base = (Serializable)OptionUtils.forName(Serializable.class, (String)tmpStr, (String[])Utils.partitionOptions((String[])options));
        this.setBaseObject(base);
        Vector<String> search = new Vector<String>();
        do {
            if ((tmpStr = Utils.getOption((String)"search", (String[])options)).length() <= 0) continue;
            search.add(tmpStr);
        } while (tmpStr.length() > 0);
        if (search.size() == 0) {
            throw new IllegalArgumentException("No search parameters provided!");
        }
        AbstractParameter[] params = new AbstractParameter[search.size()];
        for (int i = 0; i < search.size(); ++i) {
            String[] tmpOptions = Utils.splitOptions((String)((String)search.get(i)));
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            params[i] = (AbstractParameter)OptionUtils.forName(AbstractParameter.class, (String)tmpStr, (String[])tmpOptions);
        }
        this.setParameters(params);
    }

    public String baseObjectFileTipText() {
        return "The base object to set the parameters for.";
    }

    public void setBaseObject(Serializable obj) {
        this.m_BaseObject = obj;
        this.reset();
    }

    public Serializable getBaseObject() {
        return this.m_BaseObject;
    }

    public String parametersFileTipText() {
        return "The parameter definitions.";
    }

    public void setParameters(AbstractParameter[] value) {
        this.m_Parameters = value;
        this.reset();
    }

    public AbstractParameter[] getParameters() {
        return this.m_Parameters;
    }

    public void reset() {
        this.m_Initialized = false;
        this.m_Space = null;
    }

    public void setSpace(Space value) {
        this.m_Space = value;
        this.m_Initialized = false;
    }

    public Space getSpace() {
        this.initialize();
        return this.m_Space;
    }

    protected void initialize() {
        if (this.m_Initialized) {
            return;
        }
        if (this.m_BaseObject == null) {
            throw new IllegalStateException("No base object set!");
        }
        if (this.m_Space == null) {
            SpaceDimension[] dims = new SpaceDimension[this.m_Parameters.length];
            for (int i = 0; i < this.m_Parameters.length; ++i) {
                try {
                    dims[i] = new SpaceDimension(this.m_Parameters[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Error initializing space dimension #" + (i + 1) + ": " + e);
                }
            }
            this.m_Space = new Space(dims);
        }
        this.m_Initialized = true;
    }

    public Point<Object> evaluate(Point<Object> values) {
        Object[] evaluated = new Object[values.dimensions()];
        for (int i = 0; i < values.dimensions(); ++i) {
            if (this.m_Parameters[i] instanceof MathParameter) {
                String expr = ((MathParameter)this.m_Parameters[i]).getExpression();
                double base = ((MathParameter)this.m_Parameters[i]).getBase();
                double min = ((MathParameter)this.m_Parameters[i]).getMin();
                double max = ((MathParameter)this.m_Parameters[i]).getMax();
                double step = ((MathParameter)this.m_Parameters[i]).getStep();
                Object value = values.getValue(i);
                try {
                    HashMap<String, Double> symbols = new HashMap<String, Double>();
                    symbols.put("BASE", new Double(base));
                    symbols.put("FROM", new Double(min));
                    symbols.put("TO", new Double(max));
                    symbols.put("STEP", new Double(step));
                    symbols.put("I", new Double((Double)value));
                    evaluated[i] = MathematicalExpression.evaluate((String)expr, symbols);
                }
                catch (Exception e) {
                    evaluated[i] = Double.NaN;
                }
                continue;
            }
            if (this.m_Parameters[i] instanceof ListParameter) {
                evaluated[i] = values.getValue(i);
                continue;
            }
            throw new IllegalStateException("Unhandled parameter class '" + this.m_Parameters[i].getClass().getName() + "'!");
        }
        return new Point<Object>(evaluated);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object setValue(Object o, String path, Object value) throws Exception {
        PropertyDescriptor desc = PropertyPath.getPropertyDescriptor((Object)o, (String)path);
        Class<?> c = desc.getPropertyType();
        if (value instanceof Double) {
            double valDouble = (Double)value;
            if (c == Float.class || c == Float.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)new Float((float)valDouble));
                return o;
            } else if (c == Double.class || c == Double.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)new Double(valDouble));
                return o;
            } else if (c == Character.class || c == Character.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)new Integer((char)valDouble));
                return o;
            } else if (c == Integer.class || c == Integer.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)new Integer((int)valDouble));
                return o;
            } else if (c == Long.class || c == Long.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)new Long((long)valDouble));
                return o;
            } else {
                if (c != Boolean.class && c != Boolean.TYPE) throw new Exception("Could neither set double nor integer nor boolean value '" + valDouble + "' for '" + path + "'!");
                PropertyPath.setValue((Object)o, (String)path, (Object)(valDouble == 0.0 ? new Boolean(false) : new Boolean(true)));
            }
            return o;
        } else {
            String valString = (String)value;
            if (c == Float.class || c == Float.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)Float.valueOf(Float.parseFloat(valString)));
                return o;
            } else if (c == Double.class || c == Double.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)Double.parseDouble(valString));
                return o;
            } else if (c == Character.class || c == Character.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)Character.valueOf(valString.charAt(0)));
                return o;
            } else if (c == Integer.class || c == Integer.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)Integer.parseInt(valString));
                return o;
            } else if (c == Long.class || c == Long.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)Long.parseLong(valString));
                return o;
            } else if (c == Boolean.class || c == Boolean.TYPE) {
                PropertyPath.setValue((Object)o, (String)path, (Object)Boolean.parseBoolean(valString));
                return o;
            } else if (c == String.class) {
                PropertyPath.setValue((Object)o, (String)path, (Object)valString);
                return o;
            } else if (c == SelectedTag.class) {
                int i;
                SelectedTag selTag = (SelectedTag)PropertyPath.getValue((Object)o, (String)path);
                Tag[] tags = selTag.getTags();
                boolean found = false;
                for (i = 0; i < tags.length; ++i) {
                    if (!tags[i].getIDStr().equals(valString)) continue;
                    PropertyPath.setValue((Object)o, (String)path, (Object)new SelectedTag(tags[i].getID(), tags));
                    found = true;
                    break;
                }
                if (found) return o;
                for (i = 0; i < tags.length; ++i) {
                    if (!tags[i].getReadable().equals(valString)) continue;
                    PropertyPath.setValue((Object)o, (String)path, (Object)new SelectedTag(tags[i].getID(), tags));
                    return o;
                }
                return o;
            } else {
                if (valString.indexOf(".") <= 0) throw new Exception("Could not set list value '" + valString + "' for '" + path + "'!");
                try {
                    String[] options = Utils.splitOptions((String)valString);
                    String classname = options[0];
                    options[0] = "";
                    Object valObject = OptionUtils.forName(Object.class, (String)classname, (String[])options);
                    PropertyPath.setValue((Object)o, (String)path, (Object)valObject);
                    return o;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("Failed to instantiate object from  '" + valString + "' for '" + path + "'!");
                }
            }
        }
    }

    public Serializable setup(Serializable original, Point<Object> values) throws Exception {
        Serializable result = (Serializable)new SerializedObject((Object)original).getObject();
        for (int i = 0; i < values.dimensions(); ++i) {
            PropertyPath.PropertyContainer cnt = PropertyPath.find((Object)original, (PropertyPath.Path)new PropertyPath.Path(this.m_Parameters[i].getProperty()));
            if (cnt == null) continue;
            this.setValue(result, this.m_Parameters[i].getProperty(), values.getValue(i));
        }
        return result;
    }

    protected Serializable copy(Serializable obj) throws Exception {
        return (Serializable)new SerializedObject((Object)obj).getObject();
    }

    public Enumeration<Serializable> setups() {
        this.initialize();
        Vector<Serializable> result = new Vector<Serializable>();
        Enumeration<Point<Object>> values = this.m_Space.values();
        while (values.hasMoreElements()) {
            Point<Object> value = values.nextElement();
            Point<Object> evaluated = this.evaluate(value);
            try {
                Serializable newObj = this.setup(this.m_BaseObject, evaluated);
                result.add(newObj);
            }
            catch (Exception e) {
                System.err.println("Failed to generate setup:");
                e.printStackTrace();
                result = null;
                break;
            }
        }
        if (result != null) {
            return result.elements();
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Base object:\n");
        result.append(this.m_BaseObject.getClass().getName());
        if (this.m_BaseObject instanceof OptionHandler) {
            result.append(" " + Utils.joinOptions((String[])((OptionHandler)this.m_BaseObject).getOptions()));
        }
        result.append("Parameters:\n");
        for (int i = 0; i < this.m_Parameters.length; ++i) {
            result.append(i + 1 + ". ");
            result.append(Utils.joinOptions((String[])this.m_Parameters[i].getOptions()));
            result.append("\n");
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        SetupGenerator generator = new SetupGenerator();
        FilteredClassifier fc = new FilteredClassifier();
        fc.setFilter((Filter)new PLSFilter());
        fc.setClassifier((Classifier)new LinearRegression());
        generator.setBaseObject((Serializable)fc);
        AbstractParameter[] params = new AbstractParameter[3];
        params[0] = new MathParameter();
        ((MathParameter)params[0]).setProperty("classifier.ridge");
        ((MathParameter)params[0]).setMin(-5.0);
        ((MathParameter)params[0]).setMax(3.0);
        ((MathParameter)params[0]).setStep(1.0);
        ((MathParameter)params[0]).setBase(10.0);
        ((MathParameter)params[0]).setExpression("pow(BASE,I)");
        params[1] = new MathParameter();
        ((MathParameter)params[1]).setProperty("filter.numComponents");
        ((MathParameter)params[1]).setMin(5.0);
        ((MathParameter)params[1]).setMax(20.0);
        ((MathParameter)params[1]).setStep(1.0);
        ((MathParameter)params[1]).setBase(10.0);
        ((MathParameter)params[1]).setExpression("I");
        params[2] = new ListParameter();
        ((ListParameter)params[2]).setProperty("filter.algorithm");
        ((ListParameter)params[2]).setList("PLS1 SIMPLS");
        generator.setParameters(params);
        System.out.println("\nGenerator setup:\n\n" + generator);
        System.out.println("\nGenerated setups:\n");
        Enumeration<Serializable> setups = generator.setups();
        if (setups != null) {
            int i = 0;
            while (setups.hasMoreElements()) {
                System.out.println(++i + ". Setup:");
                Serializable obj = setups.nextElement();
                System.out.print("  " + obj.getClass().getName());
                if (obj instanceof OptionHandler) {
                    System.out.print(" " + Utils.joinOptions((String[])((OptionHandler)obj).getOptions()));
                }
                System.out.println();
            }
        } else {
            System.err.println("Encountered error in setup generation!");
        }
    }
}

