/**
 * FixedSizeErrorScalerTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.weka.predictions;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the FixedSizeErrorScaler scaler. Run from the command line with: <p/>
 * java adams.data.weka.predictions.FixedSizeErrorScalerTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class FixedSizeErrorScalerTest
  extends AbstractErrorScalerTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public FixedSizeErrorScalerTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"double_large.txt",
	"double_large.txt",
	"double_mixed.txt",
	"double_small.txt",
	"integer.txt"
    };
  }

  /**
   * Returns whether the input files contain doubles or integers.
   *
   * @return		true if input file contains integers
   */
  protected boolean[] getRegressionInputFileContainDoubles() {
    return new boolean[]{
	true,
	true,
	true,
	true,
	false
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractErrorScaler[] getRegressionSetups() {
    FixedSizeErrorScaler[]	result;

    result = new FixedSizeErrorScaler[5];

    result[0] = new FixedSizeErrorScaler();
    result[1] = new FixedSizeErrorScaler();
    result[1].setSize(50);
    result[2] = new FixedSizeErrorScaler();
    result[3] = new FixedSizeErrorScaler();
    result[4] = new FixedSizeErrorScaler();

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(FixedSizeErrorScalerTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
