/*
 * SetPropertyTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.standalone;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.VariableName;
import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.source.StringConstants;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;

/**
 * Tests the SetProperty actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3209 $
 */
public class SetPropertyTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public SetPropertyTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    GlobalActors ga = new GlobalActors();
    WekaClassifier cls = new WekaClassifier();
    cls.setName("cls");
    cls.setClassifier(new weka.classifiers.trees.J48());
    ga.setActors(new AbstractActor[]{cls});

    SetProperty set = new SetProperty();
    set.setActorName(new GlobalActorReference("cls"));
    set.setProperty("classifier.confidenceFactor");
    set.setVariableName(new VariableName("conf"));

    StringConstants sc = new StringConstants();
    sc.setStrings(new BaseString[]{
	new BaseString("0.1"),
	new BaseString("0.2"),
	new BaseString("0.3")
    });

    adams.flow.transformer.SetVariable sv = new adams.flow.transformer.SetVariable();
    sv.setVariableName(new VariableName("conf"));

    Trigger tr = new Trigger();

    Sequence seq = new Sequence();

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("vote.arff"));

    WekaFileReader fr = new WekaFileReader();

    WekaClassSelector cs = new WekaClassSelector();

    WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
    cv.setClassifier(new GlobalActorReference("cls"));

    WekaEvaluationSummary es = new WekaEvaluationSummary();
    es.setClassDetails(true);

    DumpFile df = new DumpFile();
    df.setAppend(true);
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    seq.setActors(new AbstractActor[]{sfs, fr, cs, cv, es, df});

    tr.add(0, seq);

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, set, sc, sv, tr});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new File[]{
	    new TmpFile("dumpfile.txt")});
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(SetPropertyTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
