/**
 * TmpExperimentFile.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.test;

import adams.data.WekaExperimentFile;

/**
 * A simple file handler class (for experiment files) that automatically places the
 * file in the system's tmp directory. But the user still needs to delete the
 * file manually when it's no longer used.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2823 $
 */
public class TmpExperimentFile
  extends WekaExperimentFile {

  /** for serialization. */
  private static final long serialVersionUID = 7689124528783850812L;

  /**
   * Creates a new <code>File</code> instance by converting the given
   * pathname string into an abstract pathname.  If the given string is
   * the empty string, then the result is the empty abstract pathname.
   *
   * @param   pathname  A pathname string
   */
  public TmpExperimentFile(String pathname) {
    super(System.getProperty("java.io.tmpdir") + separator + pathname);
  }
}
