/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.DownSample;
import weka.test.AdamsTestHelper;

public class DownSampleTest
extends AbstractAdamsFilterTest {
    public DownSampleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return this.getFilter(4);
    }

    public Filter getFilter(int nth) {
        DownSample result = new DownSample();
        result.setNthPoint(nth);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DownSampleTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            DownSampleTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DownSampleTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        DownSample filter = (DownSample)this.m_Filter;
        int numAtts = icopy.numAttributes();
        if (icopy.classIndex() != -1) {
            --numAtts;
        }
        numAtts /= filter.getNthPoint();
        if (icopy.classIndex() != -1) {
            ++numAtts;
        }
        DownSampleTest.assertEquals((int)numAtts, (int)result.numAttributes());
        DownSampleTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void test6() {
        this.m_Filter = this.getFilter(6);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(DownSampleTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)DownSampleTest.suite());
    }
}

