/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.M5P;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.SafeRemoveRange;
import weka.test.AdamsTestHelper;

public class SafeRemoveRangeTest
extends AbstractAdamsFilterTest {
    public SafeRemoveRangeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier((Classifier)new M5P());
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(0);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return this.getFilter("5-10", false);
    }

    public Filter getFilter(String range, boolean invert) {
        SafeRemoveRange result = new SafeRemoveRange();
        result.setInstancesIndices(range);
        result.setInvertSelection(invert);
        return result;
    }

    protected void performTest(int num) {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SafeRemoveRangeTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            SafeRemoveRangeTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SafeRemoveRangeTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        SafeRemoveRangeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SafeRemoveRangeTest.assertEquals((int)num, (int)result.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest(44);
    }

    public void testEmpty() {
        this.m_Filter = this.getFilter("first-last", false);
        this.testBuffered();
        this.performTest(0);
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("first-last", true);
        this.testBuffered();
        this.performTest(50);
    }

    public void testInverted2() {
        this.m_Filter = this.getFilter("5-10", true);
        this.testBuffered();
        this.performTest(6);
    }

    public static Test suite() {
        return new TestSuite(SafeRemoveRangeTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)SafeRemoveRangeTest.suite());
    }
}

