/*
 * WekaDatabaseReaderTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.source;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.db.SQLStatement;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.WekaDatabaseReader;
import adams.test.TmpFile;

/**
 * Tests the DatabaseReader actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4130 $
 */
public class WekaDatabaseReaderTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public WekaDatabaseReaderTest(String name) {
    super(name);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    WekaDatabaseReader dbr = new WekaDatabaseReader();
    dbr.setURL(getDatabaseURL());
    dbr.setUser(getDatabaseUser());
    dbr.setPassword(getDatabasePassword());
    dbr.setQuery(new SQLStatement("show tables"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{dbr});

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(WekaDatabaseReaderTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
