/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import adams.env.Environment;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.OptionHandler;
import weka.core.SetupGenerator;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.ListParameter;
import weka.core.setupgenerator.MathParameter;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;
import weka.test.AdamsTestHelper;
import weka.test.Regression;

public class SetupGeneratorTest
extends TestCase {
    public SetupGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Environment.setEnvironmentClass(Environment.class);
        super.setUp();
    }

    protected SetupGenerator getGenerator() {
        SetupGenerator generator = new SetupGenerator();
        FilteredClassifier fc = new FilteredClassifier();
        fc.setFilter((Filter)new PLSFilter());
        fc.setClassifier((Classifier)new LinearRegression());
        generator.setBaseObject((Serializable)fc);
        AbstractParameter[] params = new AbstractParameter[3];
        params[0] = new MathParameter();
        ((MathParameter)params[0]).setProperty("classifier.ridge");
        ((MathParameter)params[0]).setMin(-5.0);
        ((MathParameter)params[0]).setMax(3.0);
        ((MathParameter)params[0]).setStep(1.0);
        ((MathParameter)params[0]).setBase(10.0);
        ((MathParameter)params[0]).setExpression("pow(BASE,I)");
        params[1] = new MathParameter();
        ((MathParameter)params[1]).setProperty("filter.numComponents");
        ((MathParameter)params[1]).setMin(5.0);
        ((MathParameter)params[1]).setMax(20.0);
        ((MathParameter)params[1]).setStep(1.0);
        ((MathParameter)params[1]).setBase(10.0);
        ((MathParameter)params[1]).setExpression("I");
        params[2] = new ListParameter();
        ((ListParameter)params[2]).setProperty("filter.algorithm");
        ((ListParameter)params[2]).setList("PLS1 SIMPLS");
        generator.setParameters(params);
        return generator;
    }

    public void testTypical() {
        SetupGenerator generator = this.getGenerator();
        Enumeration setups = generator.setups();
        SetupGeneratorTest.assertNotNull((String)"Error encountered in setup generation", (Object)setups);
        SetupGeneratorTest.assertTrue((String)"Failed to generate setups", (boolean)setups.hasMoreElements());
        int count = 0;
        while (setups.hasMoreElements()) {
            Serializable obj = (Serializable)setups.nextElement();
            SetupGeneratorTest.assertNotNull((String)("Problem with setup #" + ++count), (Object)obj);
        }
    }

    public void testRegression() throws Exception {
        StringBuilder results = new StringBuilder();
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        SetupGenerator generator = this.getGenerator();
        Enumeration setups = generator.setups();
        SetupGeneratorTest.assertNotNull((String)"Error encountered in setup generation", (Object)setups);
        while (setups.hasMoreElements()) {
            Serializable obj = (Serializable)setups.nextElement();
            results.append(obj.getClass().getName());
            if (obj instanceof OptionHandler) {
                results.append(" " + Utils.joinOptions((String[])((OptionHandler)obj).getOptions()));
            }
            results.append("\n");
        }
        reg.println(results.toString());
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                SetupGeneratorTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            SetupGeneratorTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }

    public static Test suite() {
        return new TestSuite(SetupGeneratorTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)SetupGeneratorTest.suite());
    }
}

