/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.data.weka.ArffUtils;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public abstract class AbstractInstanceGenerator<T extends DataContainer & ReportHandler>
extends OptionHandlingObject
implements Comparable,
CleanUpHandler,
DatabaseConnectionHandler,
ShallowCopySupporter<AbstractInstanceGenerator> {
    private static final long serialVersionUID = 5543015283566767256L;
    public static final String LABEL_TRUE = "true";
    public static final String LABEL_FALSE = "false";
    protected Instances m_OutputHeader;
    protected boolean m_AddDatabaseID;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-db-id", "addDatabaseID", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected void reset() {
        super.reset();
        this.m_OutputHeader = null;
    }

    public void cleanUp() {
        this.reset();
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public void setAddDatabaseID(boolean value) {
        this.m_AddDatabaseID = value;
        this.reset();
    }

    public boolean getAddDatabaseID() {
        return this.m_AddDatabaseID;
    }

    public String addDatabaseIDTipText() {
        return "If set to true, then the database ID will be added to the output.";
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection = value;
        this.reset();
    }

    public Instances getOutputHeader() {
        return this.m_OutputHeader;
    }

    public String checkSetup() {
        return null;
    }

    public Instance generate(T data) {
        this.checkInput(data);
        if (this.m_OutputHeader == null) {
            this.generateHeader(data);
            this.postProcessHeader(data);
        }
        this.checkHeader(data);
        Instance result = this.generateOutput(data);
        result = this.postProcessOutput(data, result);
        return result;
    }

    protected void checkInput(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract void checkHeader(T var1);

    protected abstract void generateHeader(T var1);

    protected String interpretePosition(Instances data, String position) {
        if (position.equals("first")) {
            return "1";
        }
        if (position.equals("second")) {
            return "2";
        }
        if (position.equals("third")) {
            return "3";
        }
        if (position.equals("last-2")) {
            return "" + (data.numAttributes() - 2);
        }
        if (position.equals("last-1")) {
            return "" + (data.numAttributes() - 1);
        }
        if (position.equals("last")) {
            return "" + data.numAttributes();
        }
        if (position.equals("last+1")) {
            return "" + (data.numAttributes() + 1);
        }
        return position;
    }

    protected void postProcessHeader(T data) {
        if (this.m_AddDatabaseID) {
            try {
                Add add = new Add();
                add.setAttributeIndex("1");
                add.setAttributeName(ArffUtils.getDBIDName());
                add.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
                add.setInputFormat(this.m_OutputHeader);
                this.m_OutputHeader = Filter.useFilter((Instances)this.m_OutputHeader, (Filter)add);
            }
            catch (Exception e) {
                this.getSystemErr().println("Error initializing the Add filter for database ID!");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
    }

    protected abstract Instance generateOutput(T var1);

    protected Instance postProcessOutput(T data, Instance inst) {
        double[] values = inst.toDoubleArray();
        Report report = ((ReportHandler)data).getReport();
        if (this.m_AddDatabaseID) {
            int index = this.m_OutputHeader.attribute(ArffUtils.getDBIDName()).index();
            values[index] = report.getDatabaseID();
        }
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(this.m_OutputHeader);
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractInstanceGenerator shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractInstanceGenerator shallowCopy(boolean expand) {
        return (AbstractInstanceGenerator)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getGenerators() {
        return ClassLister.getSingleton().getClassnames(AbstractInstanceGenerator.class);
    }

    public static AbstractInstanceGenerator forName(String classname, String[] options) {
        AbstractInstanceGenerator result;
        try {
            result = (AbstractInstanceGenerator)OptionUtils.forName(AbstractInstanceGenerator.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractInstanceGenerator forCommandLine(String cmdline) {
        return (AbstractInstanceGenerator)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }
}

