/*
 * Decompiled with CFR 0.152.
 */
package adams.genetic;

import adams.core.ClassLister;
import adams.core.Properties;
import adams.core.Randomizable;
import adams.core.Range;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.multiprocess.Job;
import java.util.BitSet;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;

public abstract class MTAbstractGeneticAlgorithm
extends OptionHandlingObject
implements Randomizable {
    private static final long serialVersionUID = 2823734145266194843L;
    public static final String PROPS_RELATION = "relation";
    public static final String PROPS_FILTER = "filter";
    public static final String PROPS_MASK = "mask";
    protected int m_NumGenes;
    protected int m_NumChrom;
    protected int m_NumIterations;
    protected BitSet[] m_Genes;
    protected double[] m_Fitness;
    protected Range m_BestRange;
    protected boolean m_FavorZeroes;
    protected long m_Seed;
    protected Random m_Random;
    protected boolean m_Running;
    protected int m_MaxTrainTime;
    protected long m_TrainStart;

    public abstract Vector<int[]> getInitialSetups();

    protected void initialize() {
        super.initialize();
        this.m_NumGenes = 0;
        this.m_BestRange = new Range();
    }

    protected void reset() {
        super.reset();
        this.m_Random = new Random(this.m_Seed);
        this.m_Running = false;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-chrom", "numChrom", (Object)50);
        this.m_OptionManager.add("num-iter", "numIterations", (Object)10000000);
        this.m_OptionManager.add("seed", "seed", (Object)1);
        this.m_OptionManager.add("favor-zeroes", "favorZeroes", (Object)false);
        this.m_OptionManager.add("best", "bestRange", (Object)"-none-");
        this.m_OptionManager.add("max-train", "maxTrainTime", (Object)0);
    }

    protected void setBestRange(Range value) {
        this.m_BestRange = value;
        this.reset();
    }

    public void setBestRange(String value) {
        if (value.equals("-none-")) {
            this.setBestRange(new Range());
        } else {
            this.setBestRange(new Range(value));
        }
    }

    public String getBestRange() {
        if (this.m_BestRange.getRange().length() == 0) {
            return "-none-";
        }
        return this.m_BestRange.getRange();
    }

    public String bestRangeTipText() {
        return "The range of the best attributes.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public void setFavorZeroes(boolean value) {
        this.m_FavorZeroes = value;
        this.reset();
    }

    public boolean getFavorZeroes() {
        return this.m_FavorZeroes;
    }

    public String favorZeroesTipText() {
        return "Whether to favor 0s instead of 1s.";
    }

    public int getNumGenes() {
        return this.m_NumGenes;
    }

    public void setNumChrom(int value) {
        this.m_NumChrom = value;
        this.reset();
    }

    public int getNumChrom() {
        return this.m_NumChrom;
    }

    public String numChromTipText() {
        return "The number of chromosomes, ie, the population size.";
    }

    public void setNumIterations(int value) {
        this.m_NumIterations = value;
        this.reset();
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform.";
    }

    public void setMaxTrainTime(int value) {
        this.m_MaxTrainTime = value;
        this.reset();
    }

    public int getMaxTrainTime() {
        return this.m_MaxTrainTime;
    }

    public String maxTrainTimeTipText() {
        return "The maximum number of seconds to training time (0 = unlimited time).";
    }

    public void stop() {
        this.m_Running = false;
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public double[] getFitness() {
        return this.m_Fitness;
    }

    protected void init(int ch, int genes) {
        this.m_NumChrom = ch;
        this.m_NumGenes = genes;
        this.debug("Numchrom=" + ch + "Numgene=" + genes);
        this.m_Genes = new BitSet[this.m_NumChrom];
        Vector<int[]> setups = this.getInitialSetups();
        for (int i = 0; i < this.m_NumChrom; ++i) {
            this.m_Genes[i] = new BitSet(this.m_NumGenes);
            if (i < setups.size()) {
                int[] gene = setups.get(i);
                for (int j = 0; j < this.m_NumGenes; ++j) {
                    if (gene[j] != 1) continue;
                    this.m_Genes[i].set(j);
                }
                continue;
            }
            for (int j = 0; j < this.m_NumGenes; ++j) {
                double set = this.m_Random.nextDouble();
                if (!(set < 0.5)) continue;
                this.m_Genes[i].set(j);
            }
        }
        this.m_Fitness = new double[this.m_NumChrom];
        for (int f = 0; f < this.m_NumChrom; ++f) {
            this.m_Fitness[f] = 0.0;
        }
        this.sort();
    }

    public boolean getGene(int chromosome, int gene) {
        return this.m_Genes[chromosome].get(gene);
    }

    public void setGene(int chromosome, int gene, int value) {
        this.setGene(chromosome, gene, value != 0);
    }

    public void setGene(int chromosome, int gene, boolean value) {
        if (value) {
            this.m_Genes[chromosome].set(gene);
        } else {
            this.m_Genes[chromosome].clear(gene);
        }
    }

    public boolean hasMoreZeroes(BitSet a, BitSet b) {
        return a.cardinality() < b.cardinality();
    }

    public void sort() {
        for (int c = 0; c < this.m_NumChrom; ++c) {
            for (int d = this.m_NumChrom - 2; d >= c; --d) {
                double x;
                BitSet btemp;
                if (this.m_Fitness[d] < this.m_Fitness[d + 1]) {
                    btemp = this.m_Genes[d];
                    x = this.m_Fitness[d];
                    this.m_Genes[d] = this.m_Genes[d + 1];
                    this.m_Fitness[d] = this.m_Fitness[d + 1];
                    this.m_Genes[d + 1] = btemp;
                    this.m_Fitness[d + 1] = x;
                    continue;
                }
                if (this.m_Fitness[d] != this.m_Fitness[d + 1] || !this.hasMoreZeroes(this.m_Genes[d + 1], this.m_Genes[d])) continue;
                btemp = this.m_Genes[d];
                x = this.m_Fitness[d];
                this.m_Genes[d] = this.m_Genes[d + 1];
                this.m_Fitness[d] = this.m_Fitness[d + 1];
                this.m_Genes[d + 1] = btemp;
                this.m_Fitness[d + 1] = x;
            }
        }
    }

    public void doCrossovers() {
        for (int m = 0; m < this.m_NumChrom / 4; ++m) {
            this.copyGene(m + this.m_NumChrom * 3 / 4, m);
        }
        if (this.m_NumChrom > 4) {
            for (int i = 0; i < this.m_NumGenes; ++i) {
                this.setGene(this.m_NumChrom - 1, i, this.getGene(0, i));
                this.setGene(this.m_NumChrom - 2, i, this.getGene(0, i));
                this.setGene(this.m_NumChrom - 3, i, this.getGene(0, i));
                this.setGene(this.m_NumChrom - 4, i, this.getGene(1, i));
                this.setGene(this.m_NumChrom - 5, i, this.getGene(1, i));
            }
        }
        int num = this.m_NumChrom / 4;
        for (int i = 0; i < num; ++i) {
            int c2;
            int c1 = 2 + (int)((double)(this.m_NumChrom - 2) * this.m_Random.nextDouble() * 0.99);
            if (c1 == (c2 = 2 + (int)((double)(this.m_NumChrom - 2) * this.m_Random.nextDouble() * 0.99))) continue;
            int locus = 2 + (int)((double)(this.m_NumGenes - 3) * this.m_Random.nextDouble());
            for (int g = 0; g < locus; ++g) {
                boolean temp = this.getGene(c1, i);
                this.setGene(c1, i, this.getGene(c2, i));
                this.setGene(c2, i, temp);
            }
        }
    }

    protected void copyGene(int to, int from) {
        for (int i = 0; i < this.m_NumGenes; ++i) {
            if (this.getGene(from, i)) {
                this.setGene(to, i, 1);
                continue;
            }
            this.setGene(to, i, 0);
        }
    }

    public void doMutations() {
        int i = 0;
        while ((double)i < (double)this.m_NumChrom * 0.5) {
            int g;
            int c = 0 + (int)((double)(this.m_NumChrom - 2) * this.m_Random.nextDouble() * 0.95);
            if (this.getGene(c, g = (int)((double)this.m_NumGenes * this.m_Random.nextDouble() * 0.95))) {
                this.setGene(c, g, 0);
            } else {
                this.setGene(c, g, 1);
            }
            ++i;
        }
    }

    public void doMutations2() {
        int i = 0;
        while ((double)i < (double)this.m_NumChrom * 0.5) {
            int c = 2 + (int)((double)(this.m_NumChrom - 2) * this.m_Random.nextDouble() * 0.99);
            double thresh = 1.0 / (double)this.m_NumGenes;
            for (int gn = 0; gn < this.m_NumGenes; ++gn) {
                if (!(this.m_Random.nextDouble() < thresh)) continue;
                if (this.getGene(c, gn)) {
                    this.setGene(c, gn, 0);
                    continue;
                }
                this.setGene(c, gn, 1);
            }
            ++i;
        }
    }

    public abstract void calcFitness();

    protected Properties storeSetup(Instances data, GeneticAlgorithmJob job) {
        Properties result = new Properties();
        result.setProperty(PROPS_RELATION, data.relationName());
        result.setProperty(PROPS_FILTER, "");
        return result;
    }

    public Instances updateHeader(Instances data, GeneticAlgorithmJob job) {
        Properties props = this.storeSetup(data, job);
        data.setRelationName(props.toString());
        return data;
    }

    protected void preRun() {
        this.m_Running = true;
        this.m_TrainStart = System.currentTimeMillis();
        if (this.getDebugLevel() > 1) {
            this.debug("Size preRun: " + this.sizeOf(), 2);
        }
    }

    public boolean run() {
        boolean result = true;
        try {
            this.preRun();
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace((Throwable)e);
            result = false;
        }
        if (result) {
            try {
                for (int i = 0; i < this.getNumIterations(); ++i) {
                    if (i % 100 == 0) {
                        this.getSystemOut().println("Iteration " + (i + 1) + "/" + this.m_NumIterations);
                    }
                    this.calcFitness();
                    this.sort();
                    if (this.isDebugOn()) {
                        this.getDebugging().println("Generation " + String.valueOf(i));
                        for (int cx = 0; cx < this.getNumChrom(); ++cx) {
                            this.getDebugging().printPrefix();
                            this.getDebugging().print(" Fitness for chromosome ");
                            if (cx != -1) {
                                for (int po = 0; po < this.getNumGenes(); ++po) {
                                    if (this.getGene(cx, po)) {
                                        this.getDebugging().print("1");
                                        continue;
                                    }
                                    this.getDebugging().print("0");
                                }
                            }
                            this.getDebugging().print("--->" + this.getFitness()[cx] + "\n");
                        }
                    }
                    this.doCrossovers();
                    this.doMutations2();
                    if (this.m_MaxTrainTime > 0 && (double)(System.currentTimeMillis() - this.m_TrainStart) / 1000.0 >= (double)this.m_MaxTrainTime) {
                        this.getDebugging().println("Training time limit of " + this.m_MaxTrainTime + " seconds exceeded - stopping.");
                    } else {
                        if (this.isRunning()) continue;
                        this.getSystemErr().println("Interrupted!");
                    }
                    break;
                }
            }
            catch (Exception e) {
                result = false;
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        try {
            this.postRun();
        }
        catch (Exception e) {
            result = false;
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    protected void postRun() throws Exception {
        this.m_Running = false;
        if (this.getDebugLevel() > 1) {
            this.debug("Size postRun: " + this.sizeOf(), 2);
        }
    }

    public static void runGeneticAlgorithm(Class env, Class genetic, String[] options) {
        Environment.setEnvironmentClass((Class)env);
        try {
            if (OptionUtils.helpRequested((String[])options)) {
                System.out.println("Help requested...\n");
                MTAbstractGeneticAlgorithm geneticInst = MTAbstractGeneticAlgorithm.forName(genetic.getName(), new String[0]);
                System.out.println("\n" + OptionUtils.list((OptionHandler)geneticInst));
            } else {
                MTAbstractGeneticAlgorithm geneticInst = MTAbstractGeneticAlgorithm.forName(genetic.getName(), options);
                geneticInst.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] getGeneticAlgorithms() {
        return ClassLister.getSingleton().getClassnames(MTAbstractGeneticAlgorithm.class);
    }

    public static MTAbstractGeneticAlgorithm forName(String classname, String[] options) {
        MTAbstractGeneticAlgorithm result;
        try {
            result = (MTAbstractGeneticAlgorithm)((Object)OptionUtils.forName(MTAbstractGeneticAlgorithm.class, (String)classname, (String[])options));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static MTAbstractGeneticAlgorithm forCommandLine(String cmdline) {
        return (MTAbstractGeneticAlgorithm)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }

    public static abstract class GeneticAlgorithmJob
    extends Job {
        private static final long serialVersionUID = -4974865548501195622L;
        protected int[] m_weights;
        protected MTAbstractGeneticAlgorithm m_genetic;
        protected Double m_fitness;
        protected int m_chrom_num;

        public GeneticAlgorithmJob(MTAbstractGeneticAlgorithm g, int num, int[] w) {
            this.m_weights = w;
            this.m_genetic = g;
            this.m_chrom_num = num;
            this.m_fitness = null;
        }

        public MTAbstractGeneticAlgorithm getGenetic() {
            return this.m_genetic;
        }

        public int[] getWeights() {
            return this.m_weights;
        }

        public int getNumChrom() {
            return this.m_chrom_num;
        }

        public Double getFitness() {
            return this.m_fitness;
        }

        public String weightsToString() {
            String ret = "";
            for (int i = 0; i < this.m_weights.length; ++i) {
                ret = this.m_weights[i] == 0 ? ret + "0" : ret + "1";
            }
            return ret;
        }

        public abstract void calcNewFitness();

        protected String preProcessCheck() {
            if (this.m_genetic == null) {
                return "Doesn't belong to genetic algorithm!";
            }
            return null;
        }

        protected void process() {
            this.calcNewFitness();
        }

        protected String postProcessCheck() {
            return null;
        }

        public void cleanUp() {
            super.cleanUp();
            this.m_weights = null;
            this.m_genetic = null;
        }

        public String toString() {
            return ((Object)((Object)this.m_genetic)).getClass().getName() + ",#chrom=" + this.m_chrom_num + ",fitness=" + this.m_fitness + ",weights=" + this.weightsToString();
        }
    }
}

