/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.statistics.StatCalc;
import adams.data.utils.SAXUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;

public class SAX
extends SimpleStreamFilter {
    private static final long serialVersionUID = -7011253199243036622L;
    protected int m_bins = 5;
    protected int m_windows = 80;
    protected boolean m_OutputNominal = false;
    protected double[] m_bps = null;

    public String globalInfo() {
        return "A SAX filter.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tNumber of gaussian bins (>1).\n\t(default: 5)", "bins", 5, "-bins <int>"));
        result.addElement(new Option("\tNumber of windows for PAA (>1).\n\t(default: 80)", "windows", 80, "-windows <int>"));
        result.add(new Option("\tTrue: output nominal attributes \n\tFalse: output numeric.", "D", 0, "-D"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        this.setNominal(Utils.getFlag((char)'D', (String[])options));
        String tmpStr = Utils.getOption((String)"bins", (String[])options);
        if (tmpStr.length() > 0) {
            this.setBins(Integer.parseInt(tmpStr));
        } else {
            this.setBins(5);
        }
        tmpStr = Utils.getOption((String)"windows", (String[])options);
        if (tmpStr.length() > 0) {
            this.setWindows(Integer.parseInt(tmpStr));
        } else {
            this.setWindows(80);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getNominal()) {
            result.add("-D");
        }
        result.add("-bins");
        result.add("" + this.getBins());
        result.add("-windows");
        result.add("" + this.getWindows());
        return result.toArray(new String[result.size()]);
    }

    public String nominalTipText() {
        return "Output Nominal values? Or numeric.";
    }

    public void setNominal(boolean nominal) {
        this.m_OutputNominal = nominal;
    }

    public boolean getNominal() {
        return this.m_OutputNominal;
    }

    public void setBins(int value) {
        if (value > 0) {
            this.m_bins = value;
            this.reset();
        } else {
            System.err.println("'n' must be larger than 0 (provided: " + value + ")!");
        }
    }

    public void setWindows(int value) {
        if (value > 0) {
            this.m_windows = value;
            this.reset();
        } else {
            System.err.println("'n' must be larger than 0 (provided: " + value + ")!");
        }
    }

    public int getBins() {
        return this.m_bins;
    }

    public int getWindows() {
        return this.m_windows;
    }

    public String binsPointTipText() {
        return "number of gaussian bins (>0).";
    }

    public String windowsPointTipText() {
        return "number of windows for PAA (>0).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        boolean hasClass = inputFormat.classIndex() > -1;
        FastVector values = new FastVector();
        if (this.m_OutputNominal) {
            for (i = 0; i < this.m_bins; ++i) {
                values.addElement((Object)("" + i));
            }
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        boolean count = false;
        for (i = 0; i < this.getWindows(); ++i) {
            if (this.m_OutputNominal) {
                atts.add(new Attribute("SAX_" + (i + 1), (List)values));
                continue;
            }
            atts.add(new Attribute("SAX_" + (i + 1)));
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected double[] getMeanStdev(Instance in) {
        double[] ret = new double[2];
        StatCalc st = new StatCalc();
        for (int i = 0; i < in.numAttributes(); ++i) {
            if (i == in.classIndex()) continue;
            st.enter(in.value(i));
        }
        ret[0] = st.getMean();
        ret[1] = st.getStandardDeviation();
        return ret;
    }

    protected Instance process(Instance instance) throws Exception {
        if (this.getDebug()) {
            double[] stats = this.getMeanStdev(instance);
            System.err.println("Instance mean=" + stats[0] + ", sd=" + stats[1]);
        }
        boolean hasClass = instance.classIndex() > -1;
        double[] ivals = new double[instance.numAttributes() - 1];
        int count = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex()) continue;
            ivals[count] = instance.value(i);
            ++count;
        }
        if (this.m_bps == null) {
            this.m_bps = SAXUtils.calcBreakPoints(this.getBins());
        }
        double[] saxvalues = SAXUtils.toSAX(ivals, this.getWindows(), this.m_bps);
        double[] values = new double[this.getOutputFormat().numAttributes()];
        for (int i = 0; i < saxvalues.length; ++i) {
            values[i] = saxvalues[i];
        }
        if (hasClass) {
            values[values.length - 1] = instance.classValue();
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        result.setDataset(this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1906 $");
    }

    public static void main(String[] args) {
        SAX.runFilter((Filter)new SAX(), (String[])args);
    }
}

