/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.io.SpreadSheet;
import adams.data.conversion.AbstractConversion;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class SpreadSheetToWekaInstances
extends AbstractConversion {
    private static final long serialVersionUID = 867886761713927179L;

    public String globalInfo() {
        return "Generates a weke.core.Instances object from a SpreadSheet object.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Instances.class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet.Cell cell;
        SpreadSheet.Row row;
        int n;
        int i;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (sheet.isNumeric(i)) {
                atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent()));
                continue;
            }
            HashSet<String> unique = new HashSet<String>();
            for (n = 0; n < sheet.getRowCount(); ++n) {
                row = sheet.getRow(n);
                cell = row.getCell(i);
                if (cell == null || cell.isMissing()) continue;
                unique.add(cell.getContent());
            }
            ArrayList labels = new ArrayList(unique);
            Collections.sort(labels);
            atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent(), labels));
        }
        Instances result = new Instances(Environment.getInstance().getProject(), atts, sheet.getRowCount());
        if (sheet.hasName()) {
            result.setRelationName(sheet.getName());
        }
        for (n = 0; n < sheet.getRowCount(); ++n) {
            row = sheet.getRow(n);
            double[] values = new double[result.numAttributes()];
            for (i = 0; i < result.numAttributes(); ++i) {
                cell = row.getCell(i);
                values[i] = Utils.missingValue();
                if (cell != null && !cell.isMissing()) {
                    values[i] = result.attribute(i).isNumeric() ? Double.parseDouble(cell.getContent()) : (double)result.attribute(i).indexOfValue(cell.getContent());
                }
                DenseInstance inst = new DenseInstance(1.0, values);
                result.add((Instance)inst);
            }
        }
        return result;
    }
}

