/*
 * WekaRelationNameTest.java
 * Copyright (C) 2010-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpFile;

/**
 * Tests the WekaRelationName actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2934 $
 */
public class WekaRelationNameTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public WekaRelationNameTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies from resource files into
   * the tmp directory
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("vote.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    DumpFile df = new DumpFile();
    df.setName("sink");
    df.setAppend(true);
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{
	df
    });

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("vote.arff"));

    WekaFileReader fr = new WekaFileReader();

    Copy copy = new Copy();

    WekaRenameRelation ren1 = new WekaRenameRelation();
    ren1.setReplace("branch1");
    WekaRelationName rel1 = new WekaRelationName();
    GlobalSink sink1 = new GlobalSink();
    sink1.setGlobalName(new GlobalActorReference("sink"));
    Sequence seq1 = new Sequence();
    seq1.setActors(new AbstractActor[]{
	ren1,
	rel1,
	sink1
    });

    WekaRenameRelation ren2 = new WekaRenameRelation();
    ren2.setReplace("branch2");
    WekaRelationName rel2 = new WekaRelationName();
    GlobalSink sink2 = new GlobalSink();
    sink2.setGlobalName(new GlobalActorReference("sink"));
    Sequence seq2 = new Sequence();
    seq2.setActors(new AbstractActor[]{
	ren2,
	rel2,
	sink2
    });

    Branch br = new Branch();
    br.setNumThreads(0);
    br.setBranches(new AbstractActor[]{
	seq1,
	seq2
    });

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, sfs, fr, copy, br});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.txt"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(WekaRelationNameTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
