/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.VariableName;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.source.StringConstants;
import adams.flow.standalone.GlobalActors;
import adams.flow.standalone.SetProperty;
import adams.flow.transformer.SetVariable;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class SetPropertyTest
extends AbstractFlowTest {
    public SetPropertyTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        GlobalActors ga = new GlobalActors();
        WekaClassifier cls = new WekaClassifier();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        ga.setActors(new AbstractActor[]{cls});
        SetProperty set = new SetProperty();
        set.setActorName(new GlobalActorReference("cls"));
        set.setProperty("classifier.confidenceFactor");
        set.setVariableName(new VariableName("conf"));
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("0.1"), new BaseString("0.2"), new BaseString("0.3")});
        SetVariable sv = new SetVariable();
        sv.setVariableName(new VariableName("conf"));
        Trigger tr = new Trigger();
        Sequence seq = new Sequence();
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new GlobalActorReference("cls"));
        WekaEvaluationSummary es = new WekaEvaluationSummary();
        es.setClassDetails(true);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        seq.setActors(new AbstractActor[]{sfs, fr, cs, cv, es, df});
        tr.add(0, (AbstractActor)seq);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, set, sc, sv, tr});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(SetPropertyTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SetPropertyTest.runTest((Test)SetPropertyTest.suite());
    }
}

