/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.XmlErrorHandler;
import com.sun.rowset.internal.XmlReaderContentHandler;
import com.sun.rowset.internal.XmlResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.XmlReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class WebRowSetXmlReader
implements XmlReader,
Serializable {
    private transient JdbcRowSetResourceBundle wrsReaderResBundle;

    public WebRowSetXmlReader() {
        try {
            this.wrsReaderResBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readXML(WebRowSet webRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            XmlReaderContentHandler xmlReaderContentHandler = new XmlReaderContentHandler(webRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new XmlResolver());
            xMLReader.setContentHandler(xmlReaderContentHandler);
            xMLReader.setErrorHandler(xmlErrorHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println(this.wrsReaderResBundle.handleGetObject("wrsxmlreader.parseerr").toString() + this.wrsReaderResBundle.handleGetObject("wrsxmlreader.line").toString() + sAXParseException.getLineNumber() + this.wrsReaderResBundle.handleGetObject("wrsxmlreader.uri").toString() + sAXParseException.getSystemId());
            System.out.println(sAXParseException.getMessage());
            sAXParseException.printStackTrace();
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw new SQLException(exception.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException(this.wrsReaderResBundle.handleGetObject("wrsxmlreader.invalidcp").toString());
        }
        catch (Throwable throwable) {
            throw new SQLException(this.wrsReaderResBundle.handleGetObject("wrsxmlreader.readxml").toString() + throwable.getMessage());
        }
    }

    public void readXML(WebRowSet webRowSet, InputStream inputStream) throws SQLException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            XmlReaderContentHandler xmlReaderContentHandler = new XmlReaderContentHandler(webRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new XmlResolver());
            xMLReader.setContentHandler(xmlReaderContentHandler);
            xMLReader.setErrorHandler(xmlErrorHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println(this.wrsReaderResBundle.handleGetObject("wrsxmlreader.parseerr").toString() + this.wrsReaderResBundle.handleGetObject("wrsxmlreader.line").toString() + sAXParseException.getLineNumber() + this.wrsReaderResBundle.handleGetObject("wrsxmlreader.uri").toString() + sAXParseException.getSystemId());
            System.out.println(sAXParseException.getMessage());
            sAXParseException.printStackTrace();
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw new SQLException(exception.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException(this.wrsReaderResBundle.handleGetObject("wrsxmlreader.invalidcp").toString());
        }
        catch (Throwable throwable) {
            throw new SQLException(this.wrsReaderResBundle.handleGetObject("wrsxmlreader.readxml").toString() + throwable.getMessage());
        }
    }

    public void readData(RowSetInternal rowSetInternal) {
    }
}

