/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class MeasurementsWriter
implements PlugIn {
    public void run(String path) {
        this.save(path);
    }

    public boolean save(String path) {
        if (IJ.isResultsWindow()) {
            TextPanel tp = IJ.getTextPanel();
            if (tp != null && !tp.saveAs(path)) {
                return false;
            }
        } else {
            ResultsTable rt = ResultsTable.getResultsTable();
            if (rt == null || rt.getCounter() == 0) {
                return false;
            }
            if (path.equals("")) {
                SaveDialog sd = new SaveDialog("Save as Text", "Results", Prefs.get("options.ext", ".xls"));
                String file = sd.getFileName();
                if (file == null) {
                    return false;
                }
                path = sd.getDirectory() + file;
            }
            PrintWriter pw = null;
            try {
                FileOutputStream fos = new FileOutputStream(path);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                pw = new PrintWriter(bos);
            }
            catch (IOException e) {
                IJ.log("MeasurementsWriter: " + e);
                return false;
            }
            int n = rt.getCounter();
            for (int i = 0; i < n; ++i) {
                pw.println(rt.getRowAsString(i));
            }
            pw.close();
        }
        return true;
    }
}

