/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class URLOpener
implements PlugIn {
    private static String url = "http://rsb.info.nih.gov/ij/images/clown.gif";

    public void run(String urlOrName) {
        if (!urlOrName.equals("")) {
            if (urlOrName.endsWith("StartupMacros.txt")) {
                this.openTextFile(urlOrName, true);
            } else {
                String url = urlOrName.indexOf("://") > 0 ? urlOrName : Prefs.getImagesURL() + urlOrName;
                ImagePlus imp = new ImagePlus(url);
                if (Recorder.record) {
                    Recorder.recordCall("imp = IJ.openImage(\"" + url + "\");");
                }
                if (imp.getType() == 4) {
                    Opener.convertGrayJpegTo8Bits(imp);
                }
                WindowManager.checkForDuplicateName = true;
                FileInfo fi = imp.getOriginalFileInfo();
                if (fi != null && fi.fileType == 12) {
                    imp = new CompositeImage(imp, 1);
                } else if (imp.getNChannels() > 1 && fi != null && fi.description != null && fi.description.indexOf("mode=") != -1) {
                    int mode = 2;
                    if (fi.description.indexOf("mode=composite") != -1) {
                        mode = 1;
                    } else if (fi.description.indexOf("mode=gray") != -1) {
                        mode = 3;
                    }
                    imp = new CompositeImage(imp, mode);
                }
                imp.show();
            }
            return;
        }
        GenericDialog gd = new GenericDialog("Enter a URL");
        gd.addMessage("Enter URL of an image, macro or web page");
        gd.addStringField("URL:", url, 45);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        url = gd.getNextString();
        if ((url = url.trim()).indexOf("://") == -1) {
            url = "http://" + url;
        }
        if (url.endsWith("/")) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url.substring(0, url.length() - 1));
        } else if (url.endsWith(".html") || url.endsWith(".htm") || url.indexOf(".html#") > 0 || this.noExtension(url)) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
        } else if (url.endsWith(".txt") || url.endsWith(".ijm") || url.endsWith(".js") || url.endsWith(".java")) {
            this.openTextFile(url, false);
        } else if (url.endsWith(".jar") || url.endsWith(".class")) {
            IJ.open(url);
        } else {
            IJ.showStatus("Opening: " + url);
            ImagePlus imp = new ImagePlus(url);
            WindowManager.checkForDuplicateName = true;
            FileInfo fi = imp.getOriginalFileInfo();
            if (fi != null && fi.fileType == 12) {
                imp = new CompositeImage(imp, 1);
            }
            imp.show();
            IJ.showStatus("");
        }
        IJ.register(URLOpener.class);
    }

    boolean noExtension(String url) {
        int lastDot;
        int lastSlash = url.lastIndexOf("/");
        if (lastSlash == -1) {
            lastSlash = 0;
        }
        return (lastDot = url.lastIndexOf(".")) == -1 || lastDot < lastSlash || url.length() - lastDot > 6;
    }

    void openTextFile(String urlString, boolean install) {
        StringBuffer sb = null;
        try {
            String line;
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            if (!install || !urlString.endsWith("StartupMacros.txt")) {
                IJ.error("URL Opener", "" + e);
            }
            sb = null;
        }
        if (sb != null) {
            if (install) {
                new MacroInstaller().install(new String(sb));
            } else {
                int index = urlString.lastIndexOf("/");
                if (index != -1 && index <= urlString.length() - 1) {
                    urlString = urlString.substring(index + 1);
                }
                new Editor().create(urlString, new String(sb));
            }
        }
    }
}

