/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.ColorProcessor;
import ij.process.ColorStatistics;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.PolygonFiller;
import ij.process.ShortProcessor;
import ij.process.ShortStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Properties;

public class ParticleAnalyzer
implements PlugInFilter,
Measurements {
    public static final int SHOW_RESULTS = 1;
    public static final int SHOW_SUMMARY = 2;
    public static final int SHOW_OUTLINES = 4;
    public static final int EXCLUDE_EDGE_PARTICLES = 8;
    public static final int SHOW_ROI_MASKS = 16;
    public static final int SHOW_PROGRESS = 32;
    public static final int CLEAR_WORKSHEET = 64;
    public static final int RECORD_STARTS = 128;
    public static final int DISPLAY_SUMMARY = 256;
    public static final int SHOW_NONE = 512;
    public static final int INCLUDE_HOLES = 1024;
    public static final int ADD_TO_MANAGER = 2048;
    public static final int SHOW_MASKS = 4096;
    public static final int FOUR_CONNECTED = 8192;
    static final String OPTIONS = "ap.options";
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    static final double DEFAULT_MIN_SIZE = 0.0;
    static final double DEFAULT_MAX_SIZE = Double.POSITIVE_INFINITY;
    private static double staticMinSize = 0.0;
    private static double staticMaxSize = Double.POSITIVE_INFINITY;
    private static boolean pixelUnits;
    private static int staticOptions;
    private static String[] showStrings;
    private static double minCircularity;
    private static double maxCircularity;
    private static String prevHdr;
    protected static final int NOTHING = 0;
    protected static final int OUTLINES = 1;
    protected static final int MASKS = 2;
    protected static final int ELLIPSES = 3;
    protected static final int ROI_MASKS = 4;
    protected static int showChoice;
    protected ImagePlus imp;
    protected ResultsTable rt;
    protected Analyzer analyzer;
    protected int slice;
    protected boolean processStack;
    protected boolean showResults;
    protected boolean excludeEdgeParticles;
    protected boolean showSizeDistribution;
    protected boolean resetCounter;
    protected boolean showProgress;
    protected boolean recordStarts;
    protected boolean displaySummary;
    protected boolean floodFill;
    protected boolean addToManager;
    private String summaryHdr = "Slice\tCount\tTotal Area\tAverage Size\tArea Fraction";
    private double level1;
    private double level2;
    private double minSize;
    private double maxSize;
    private int options;
    private int measurements;
    private Calibration calibration;
    private String arg;
    private double fillColor;
    private boolean thresholdingLUT;
    private ImageProcessor drawIP;
    private int width;
    private int height;
    private boolean canceled;
    private ImageStack outlines;
    private IndexColorModel customLut;
    private int particleCount;
    private int maxParticleCount = 0;
    private int totalCount;
    private TextWindow tw;
    private Wand wand;
    private int imageType;
    private int imageType2;
    private boolean roiNeedsImage;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private ImagePlus redirectImp;
    private ImageProcessor redirectIP;
    private PolygonFiller pf;
    private Roi saveRoi;
    private int beginningCount;
    private Rectangle r;
    private ImageProcessor mask;
    private double totalArea;
    private FloodFiller ff;
    private Polygon polygon;
    private RoiManager roiManager;
    private ImagePlus outputImage;
    private boolean hideOutputImage;
    private int roiType;
    private int wandMode = 1;
    int counter = 0;

    public ParticleAnalyzer(int options, int measurements, ResultsTable rt, double minSize, double maxSize, double minCirc, double maxCirc) {
        this.options = options;
        this.measurements = measurements;
        this.rt = rt;
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
        minCircularity = minCirc;
        maxCircularity = maxCirc;
        this.slice = 1;
        if ((options & 0x10) != 0) {
            showChoice = 4;
        }
        if ((options & 4) != 0) {
            showChoice = 1;
        }
        if ((options & 0x1000) != 0) {
            showChoice = 2;
        }
        if ((options & 0x200) != 0) {
            showChoice = 0;
        }
        if ((options & 0x2000) != 0) {
            this.wandMode = 4;
            options |= 0x400;
        }
    }

    public ParticleAnalyzer(int options, int measurements, ResultsTable rt, double minSize, double maxSize) {
        this(options, measurements, rt, minSize, maxSize, 0.0, 1.0);
    }

    public ParticleAnalyzer() {
        this.slice = 1;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(ParticleAnalyzer.class);
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        if (imp.getBitDepth() == 24 && !this.isBinaryRGB(imp)) {
            IJ.error("Particle Analyzer", "RGB images must be converted to binary using\nProcess>Binary>Make Binary or thresholded\nusing Image>Adjust>Color Threshold.");
            return 4096;
        }
        if (!this.showDialog()) {
            return 4096;
        }
        int baseFlags = 415;
        int flags = IJ.setupDialog(imp, baseFlags);
        this.processStack = (flags & 0x20) != 0;
        this.slice = 0;
        this.saveRoi = imp.getRoi();
        if (this.saveRoi != null && this.saveRoi.getType() != 0 && this.saveRoi.isArea()) {
            this.polygon = this.saveRoi.getPolygon();
        }
        imp.startTiming();
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.imp.getStackSize() > 1 && this.processStack) {
            this.imp.setSlice(this.slice);
        }
        if (this.imp.getType() == 4) {
            ip = ip.convertToByte(false);
            int t = Prefs.blackBackground ? 255 : 0;
            ip.setThreshold(t, t, 2);
        }
        if (!this.analyze(this.imp, ip)) {
            this.canceled = true;
        }
        if (this.slice == this.imp.getStackSize()) {
            this.imp.updateAndDraw();
            if (this.saveRoi != null) {
                this.imp.setRoi(this.saveRoi);
            }
        }
    }

    public boolean showDialog() {
        String maxStr;
        String minStr;
        double cmax;
        Calibration cal = this.imp != null ? this.imp.getCalibration() : new Calibration();
        double unitSquared = cal.pixelWidth * cal.pixelHeight;
        if (pixelUnits) {
            unitSquared = 1.0;
        }
        if (Macro.getOptions() != null) {
            boolean oldMacro = this.updateMacroOptions();
            if (oldMacro) {
                unitSquared = 1.0;
            }
            staticMinSize = 0.0;
            staticMaxSize = Double.POSITIVE_INFINITY;
            minCircularity = 0.0;
            maxCircularity = 1.0;
            showChoice = 0;
        }
        GenericDialog gd = new GenericDialog("Analyze Particles");
        this.minSize = staticMinSize;
        this.maxSize = staticMaxSize;
        if (this.maxSize == 999999.0) {
            this.maxSize = Double.POSITIVE_INFINITY;
        }
        this.options = staticOptions;
        String unit = cal.getUnit();
        boolean scaled = cal.scaled();
        if (unit.equals("inch")) {
            unit = "pixel";
            unitSquared = 1.0;
            scaled = false;
            pixelUnits = true;
        }
        String units = unit + "^2";
        int places = 0;
        double cmin = this.minSize * unitSquared;
        if ((double)((int)cmin) != cmin) {
            places = 2;
        }
        if ((double)((int)(cmax = this.maxSize * unitSquared)) != cmax && cmax != Double.POSITIVE_INFINITY) {
            places = 2;
        }
        if ((minStr = ResultsTable.d2s(cmin, places)).indexOf("-") != -1) {
            for (int i = places; i <= 6 && (minStr = ResultsTable.d2s(cmin, i)).indexOf("-") != -1; ++i) {
            }
        }
        if ((maxStr = ResultsTable.d2s(cmax, places)).indexOf("-") != -1) {
            for (int i = places; i <= 6 && (maxStr = ResultsTable.d2s(cmax, i)).indexOf("-") != -1; ++i) {
            }
        }
        if (scaled) {
            gd.setInsets(5, 0, 0);
        }
        gd.addStringField("Size (" + units + "):", minStr + "-" + maxStr, 12);
        if (scaled) {
            gd.setInsets(0, 40, 5);
            gd.addCheckbox("Pixel Units", pixelUnits);
        }
        gd.addStringField("Circularity:", IJ.d2s(minCircularity) + "-" + IJ.d2s(maxCircularity), 12);
        gd.addChoice("Show:", showStrings, showStrings[showChoice]);
        String[] labels = new String[7];
        boolean[] states = new boolean[7];
        labels[0] = "Display Results";
        states[0] = (this.options & 1) != 0;
        labels[1] = "Exclude on Edges";
        states[1] = (this.options & 8) != 0;
        labels[2] = "Clear Results";
        states[2] = (this.options & 0x40) != 0;
        labels[3] = "Include Holes";
        states[3] = (this.options & 0x400) != 0;
        labels[4] = "Summarize";
        states[4] = (this.options & 0x100) != 0;
        labels[5] = "Record Starts";
        states[5] = (this.options & 0x80) != 0;
        labels[6] = "Add to Manager";
        states[6] = (this.options & 0x800) != 0;
        gd.addCheckboxGroup(4, 2, labels, states);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String size = gd.getNextString();
        if (scaled) {
            pixelUnits = gd.getNextBoolean();
        }
        unitSquared = pixelUnits ? 1.0 : cal.pixelWidth * cal.pixelHeight;
        String[] minAndMax = Tools.split(size, " -");
        double mins = Tools.parseDouble(minAndMax[0]);
        double maxs = minAndMax.length == 2 ? Tools.parseDouble(minAndMax[1]) : Double.NaN;
        this.minSize = Double.isNaN(mins) ? 0.0 : mins / unitSquared;
        double d = this.maxSize = Double.isNaN(maxs) ? Double.POSITIVE_INFINITY : maxs / unitSquared;
        if (this.minSize < 0.0) {
            this.minSize = 0.0;
        }
        if (this.maxSize < this.minSize) {
            this.maxSize = Double.POSITIVE_INFINITY;
        }
        staticMinSize = this.minSize;
        staticMaxSize = this.maxSize;
        minAndMax = Tools.split(gd.getNextString(), " -");
        double minc = Tools.parseDouble(minAndMax[0]);
        double maxc = minAndMax.length == 2 ? Tools.parseDouble(minAndMax[1]) : Double.NaN;
        minCircularity = Double.isNaN(minc) ? 0.0 : minc;
        double d2 = maxCircularity = Double.isNaN(maxc) ? 1.0 : maxc;
        if (minCircularity < 0.0 || minCircularity > 1.0) {
            minCircularity = 0.0;
        }
        if (maxCircularity < minCircularity || maxCircularity > 1.0) {
            maxCircularity = 1.0;
        }
        if (minCircularity == 1.0 && maxCircularity == 1.0) {
            minCircularity = 0.0;
        }
        if (gd.invalidNumber()) {
            IJ.error("Bins invalid.");
            this.canceled = true;
            return false;
        }
        showChoice = gd.getNextChoiceIndex();
        this.options = gd.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = gd.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = gd.getNextBoolean() ? (this.options |= 0x40) : (this.options &= 0xFFFFFFBF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x400) : (this.options &= 0xFFFFFBFF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x100) : (this.options &= 0xFFFFFEFF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x80) : (this.options &= 0xFFFFFF7F);
        this.options = gd.getNextBoolean() ? (this.options |= 0x800) : (this.options &= 0xFFFFF7FF);
        staticOptions = this.options;
        this.options |= 0x20;
        if ((this.options & 0x100) != 0) {
            Analyzer.setMeasurements(Analyzer.getMeasurements() | 1);
        }
        return true;
    }

    private boolean isBinaryRGB(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int[] pixels = (int[])ip.getPixels();
        int size = imp.getWidth() * imp.getHeight();
        for (int i = 0; i < size; ++i) {
            if ((pixels[i] & 0xFFFFFF) == 0 || (pixels[i] & 0xFFFFFF) == 0xFFFFFF) continue;
            return false;
        }
        return true;
    }

    boolean updateMacroOptions() {
        String options = Macro.getOptions();
        int index = options.indexOf("maximum=");
        if (index == -1) {
            return false;
        }
        index += 8;
        int len = options.length();
        while (index < len - 1 && options.charAt(index) != ' ') {
            ++index;
        }
        if (index == len - 1) {
            return false;
        }
        int min = (int)Tools.parseDouble(Macro.getValue(options, "minimum", "1"));
        int max = (int)Tools.parseDouble(Macro.getValue(options, "maximum", "999999"));
        options = "size=" + min + "-" + max + options.substring(index, len);
        Macro.setOptions(options);
        return true;
    }

    public boolean analyze(ImagePlus imp) {
        return this.analyze(imp, imp.getProcessor());
    }

    public boolean analyze(ImagePlus imp, ImageProcessor ip) {
        if (this.imp == null) {
            this.imp = imp;
        }
        this.showResults = (this.options & 1) != 0;
        this.excludeEdgeParticles = (this.options & 8) != 0;
        this.resetCounter = (this.options & 0x40) != 0;
        this.showProgress = (this.options & 0x20) != 0;
        this.floodFill = (this.options & 0x400) == 0;
        this.recordStarts = (this.options & 0x80) != 0;
        this.addToManager = (this.options & 0x800) != 0;
        this.displaySummary = (this.options & 0x100) != 0;
        this.outputImage = null;
        ip.snapshot();
        ip.setProgressBar(null);
        if (Analyzer.isRedirectImage()) {
            this.redirectImp = Analyzer.getRedirectImage(imp);
            if (this.redirectImp == null) {
                return false;
            }
            int depth = this.redirectImp.getStackSize();
            if (depth > 1 && depth == imp.getStackSize()) {
                ImageStack redirectStack = this.redirectImp.getStack();
                this.redirectIP = redirectStack.getProcessor(imp.getCurrentSlice());
            } else {
                this.redirectIP = this.redirectImp.getProcessor();
            }
        }
        if (!this.setThresholdLevels(imp, ip)) {
            return false;
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        if (showChoice != 0) {
            if (this.slice == 1) {
                this.outlines = new ImageStack(this.width, this.height);
            }
            this.drawIP = showChoice == 4 ? new ShortProcessor(this.width, this.height) : new ByteProcessor(this.width, this.height);
            if (showChoice != 4) {
                if (showChoice == 2) {
                    this.drawIP.invertLut();
                } else if (showChoice == 1) {
                    if (this.customLut == null) {
                        this.makeCustomLut();
                    }
                    this.drawIP.setColorModel(this.customLut);
                    this.drawIP.setFont(new Font("SansSerif", 0, 9));
                }
            }
            this.outlines.addSlice(null, this.drawIP);
            if (showChoice == 4) {
                this.drawIP.setColor(Color.black);
            } else {
                this.drawIP.setColor(Color.white);
            }
            this.drawIP.fill();
            this.drawIP.setColor(Color.black);
        }
        Calibration calibration = this.calibration = this.redirectImp != null ? this.redirectImp.getCalibration() : imp.getCalibration();
        if (this.rt == null) {
            this.rt = Analyzer.getResultsTable();
            this.analyzer = new Analyzer(imp);
        } else {
            this.analyzer = new Analyzer(imp, this.measurements, this.rt);
        }
        if (this.resetCounter && this.slice == 1 && !Analyzer.resetCounter()) {
            return false;
        }
        this.beginningCount = Analyzer.getCounter();
        byte[] pixels = null;
        if (ip instanceof ByteProcessor) {
            pixels = (byte[])ip.getPixels();
        }
        if (this.r == null) {
            this.r = ip.getRoi();
            this.mask = ip.getMask();
            if (this.displaySummary) {
                this.totalArea = this.mask != null ? ImageStatistics.getStatistics((ImageProcessor)ip, (int)1, (Calibration)this.calibration).area : (double)this.r.width * this.calibration.pixelWidth * (double)this.r.height * this.calibration.pixelHeight;
            }
        }
        this.minX = this.r.x;
        this.maxX = this.r.x + this.r.width;
        this.minY = this.r.y;
        this.maxY = this.r.y + this.r.height;
        if (!(this.r.width >= this.width && this.r.height >= this.height && this.mask == null || this.eraseOutsideRoi(ip, this.r, this.mask))) {
            return false;
        }
        int inc = Math.max(this.r.height / 25, 1);
        boolean mi = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.running = true;
        }
        if (this.measurements == 0) {
            this.measurements = Analyzer.getMeasurements();
        }
        if (showChoice == 3) {
            this.measurements |= 0x800;
        }
        this.measurements &= 0xFFFFFEFF;
        this.roiNeedsImage = (this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0 || (this.measurements & 0x4000) != 0;
        this.particleCount = 0;
        this.wand = new Wand(ip);
        this.pf = new PolygonFiller();
        if (this.floodFill) {
            ImageProcessor ipf = ip.duplicate();
            ipf.setValue(this.fillColor);
            this.ff = new FloodFiller(ipf);
        }
        this.roiType = Wand.allPoints() ? 3 : 4;
        for (int y = this.r.y; y < this.r.y + this.r.height; ++y) {
            int offset = y * this.width;
            for (int x = this.r.x; x < this.r.x + this.r.width; ++x) {
                double value = pixels != null ? (double)(pixels[offset + x] & 0xFF) : (this.imageType == 1 ? (double)ip.getPixel(x, y) : (double)ip.getPixelValue(x, y));
                if (!(value >= this.level1) || !(value <= this.level2)) continue;
                this.analyzeParticle(x, y, imp, ip);
            }
            if (this.showProgress && y % inc == 0) {
                IJ.showProgress((double)(y - this.r.y) / (double)this.r.height);
            }
            if (win != null) {
                boolean bl = this.canceled = !win.running;
            }
            if (!this.canceled) continue;
            Macro.abort();
            break;
        }
        if (this.showProgress) {
            IJ.showProgress(1.0);
        }
        if (this.showResults) {
            this.rt.updateResults();
        }
        imp.killRoi();
        ip.resetRoi();
        ip.reset();
        if (this.displaySummary && IJ.getInstance() != null) {
            this.updateSliceSummary();
        }
        if (this.addToManager && this.roiManager != null) {
            this.roiManager.setEditMode(imp, true);
        }
        this.maxParticleCount = this.particleCount > this.maxParticleCount ? this.particleCount : this.maxParticleCount;
        this.totalCount += this.particleCount;
        if (!this.canceled) {
            this.showResults();
        }
        return true;
    }

    void updateSliceSummary() {
        Frame frame;
        int slices = this.imp.getStackSize();
        float[] areas = this.rt.getColumn(0);
        String label = this.imp.getTitle();
        if (slices > 1) {
            label = this.imp.getStack().getShortSliceLabel(this.slice);
            label = label != null && !label.equals("") ? label : "" + this.slice;
        }
        String aLine = null;
        if (areas == null) {
            return;
        }
        double sum = 0.0;
        int start = areas.length - this.particleCount;
        if (start < 0) {
            return;
        }
        for (int i = start; i < areas.length; ++i) {
            sum += (double)areas[i];
        }
        int places = Analyzer.getPrecision();
        Calibration cal = this.imp.getCalibration();
        String total = "\t" + ResultsTable.d2s(sum, places);
        String average = "\t" + ResultsTable.d2s(sum / (double)this.particleCount, places);
        String fraction = "\t" + ResultsTable.d2s(sum * 100.0 / this.totalArea, 1);
        aLine = label + "\t" + this.particleCount + total + average + fraction;
        aLine = this.addMeans(aLine, start);
        if (slices == 1 && (frame = WindowManager.getFrame("Summary")) != null && frame instanceof TextWindow && this.summaryHdr.equals(prevHdr)) {
            this.tw = (TextWindow)frame;
        }
        if (this.tw == null) {
            String title = slices == 1 ? "Summary" : "Summary of " + this.imp.getTitle();
            this.tw = new TextWindow(title, this.summaryHdr, aLine, 450, 300);
            prevHdr = this.summaryHdr;
        } else {
            this.tw.append(aLine);
        }
    }

    String addMeans(String line, int start) {
        if ((this.measurements & 2) != 0) {
            line = this.addMean(1, line, start);
        }
        if ((this.measurements & 8) != 0) {
            line = this.addMean(3, line, start);
        }
        if ((this.measurements & 0x80) != 0) {
            line = this.addMean(10, line, start);
        }
        if ((this.measurements & 0x800) != 0) {
            line = this.addMean(15, line, start);
            line = this.addMean(16, line, start);
            line = this.addMean(17, line, start);
        }
        if ((this.measurements & 0x2000) != 0) {
            line = this.addMean(18, line, start);
            line = this.addMean(34, line, start);
        }
        if ((this.measurements & 0x4000) != 0) {
            line = this.addMean(19, line, start);
            line = this.addMean(28, line, start);
            line = this.addMean(29, line, start);
            line = this.addMean(30, line, start);
            line = this.addMean(31, line, start);
        }
        if ((this.measurements & 0x8000) != 0) {
            line = this.addMean(20, line, start);
        }
        if ((this.measurements & 0x10000) != 0) {
            line = this.addMean(21, line, start);
        }
        if ((this.measurements & 0x20000) != 0) {
            line = this.addMean(22, line, start);
        }
        if ((this.measurements & 0x40000) != 0) {
            line = this.addMean(23, line, start);
        }
        return line;
    }

    private String addMean(int column, String line, int start) {
        float[] c;
        float[] fArray = c = column >= 0 ? this.rt.getColumn(column) : null;
        if (c != null) {
            ImageProcessor ip = new FloatProcessor(c.length, 1, c, null);
            if (ip == null) {
                return line;
            }
            ip.setRoi(start, 0, ip.getWidth() - start, 1);
            ip = ((ImageProcessor)ip).crop();
            FloatStatistics stats = new FloatStatistics(ip);
            if (stats == null) {
                return line;
            }
            line = line + this.n(stats.mean);
        } else {
            line = line + "-\t";
        }
        this.summaryHdr = this.summaryHdr + "\t" + this.rt.getColumnHeading(column);
        return line;
    }

    String n(double n) {
        String s = (double)Math.round(n) == n ? ResultsTable.d2s(n, 0) : ResultsTable.d2s(n, Analyzer.getPrecision());
        return "\t" + s;
    }

    boolean eraseOutsideRoi(ImageProcessor ip, Rectangle r, ImageProcessor mask) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        ip.setRoi(r);
        if (this.excludeEdgeParticles && this.polygon != null) {
            ImageStatistics stats = ImageStatistics.getStatistics(ip, 16, null);
            if (this.fillColor >= stats.min && this.fillColor <= stats.max) {
                double replaceColor = this.level1 - 1.0;
                if (replaceColor < 0.0 || replaceColor == this.fillColor) {
                    int maxColor;
                    replaceColor = this.level2 + 1.0;
                    int n = maxColor = this.imageType == 0 ? 255 : 65535;
                    if (replaceColor > (double)maxColor || replaceColor == this.fillColor) {
                        IJ.error("Particle Analyzer", "Unable to remove edge particles");
                        return false;
                    }
                }
                for (int y = this.minY; y < this.maxY; ++y) {
                    for (int x = this.minX; x < this.maxX; ++x) {
                        int v = ip.getPixel(x, y);
                        if ((double)v != this.fillColor) continue;
                        ip.putPixel(x, y, (int)replaceColor);
                    }
                }
            }
        }
        ip.setValue(this.fillColor);
        if (mask != null) {
            mask = mask.duplicate();
            mask.invert();
            ip.fill(mask);
        }
        ip.setRoi(0, 0, r.x, height);
        ip.fill();
        ip.setRoi(r.x, 0, r.width, r.y);
        ip.fill();
        ip.setRoi(r.x, r.y + r.height, r.width, height - (r.y + r.height));
        ip.fill();
        ip.setRoi(r.x + r.width, 0, width - (r.x + r.width), height);
        ip.fill();
        ip.resetRoi();
        return true;
    }

    boolean setThresholdLevels(ImagePlus imp, ImageProcessor ip) {
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        boolean invertedLut = imp.isInvertedLut();
        boolean byteImage = ip instanceof ByteProcessor;
        this.imageType = ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 0);
        if (t1 == -808080.0) {
            ImageStatistics stats = imp.getStatistics();
            if (this.imageType != 0 || stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                IJ.error("Particle Analyzer", "A thresholded image or 8-bit binary image is\nrequired. Threshold levels can be set using\nthe Image->Adjust->Threshold tool.");
                this.canceled = true;
                return false;
            }
            if (invertedLut) {
                this.level1 = 255.0;
                this.level2 = 255.0;
                this.fillColor = 64.0;
            } else {
                this.level1 = 0.0;
                this.level2 = 0.0;
                this.fillColor = 192.0;
            }
        } else {
            this.level1 = t1;
            this.level2 = t2;
            if (this.imageType == 0) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 255.0) {
                    this.fillColor = 255.0;
                }
            } else if (this.imageType == 1) {
                if (this.level1 > 0.0) {
                    this.fillColor = 0.0;
                } else if (this.level2 < 65535.0) {
                    this.fillColor = 65535.0;
                }
            } else if (this.imageType == 2) {
                this.fillColor = -3.4028234663852886E38;
            } else {
                return false;
            }
        }
        this.imageType2 = this.imageType;
        if (this.redirectIP != null) {
            this.imageType2 = this.redirectIP instanceof ShortProcessor ? 1 : (this.redirectIP instanceof FloatProcessor ? 2 : (this.redirectIP instanceof ColorProcessor ? 3 : 0));
        }
        return true;
    }

    void analyzeParticle(int x, int y, ImagePlus imp, ImageProcessor ip) {
        ImageProcessor ip2 = this.redirectIP != null ? this.redirectIP : ip;
        this.wand.autoOutline(x, y, this.level1, this.level2, this.wandMode);
        if (this.wand.npoints == 0) {
            IJ.log("wand error: " + x + " " + y);
            return;
        }
        PolygonRoi roi = new PolygonRoi(this.wand.xpoints, this.wand.ypoints, this.wand.npoints, this.roiType);
        Rectangle r = roi.getBounds();
        if (r.width > 1 && r.height > 1) {
            PolygonRoi proi = roi;
            this.pf.setPolygon(proi.getXCoordinates(), proi.getYCoordinates(), proi.getNCoordinates());
            ip2.setMask(this.pf.getMask(r.width, r.height));
            if (this.floodFill) {
                this.ff.particleAnalyzerFill(x, y, this.level1, this.level2, ip2.getMask(), r);
            }
        }
        ip2.setRoi(r);
        ip.setValue(this.fillColor);
        ImageStatistics stats = this.getStatistics(ip2, this.measurements, this.calibration);
        boolean include = true;
        if (this.excludeEdgeParticles) {
            if (r.x == this.minX || r.y == this.minY || r.x + r.width == this.maxX || r.y + r.height == this.maxY) {
                include = false;
            }
            if (this.polygon != null) {
                Rectangle bounds = roi.getBounds();
                int x1 = bounds.x + this.wand.xpoints[this.wand.npoints - 1];
                int y1 = bounds.y + this.wand.ypoints[this.wand.npoints - 1];
                for (int i = 0; i < this.wand.npoints; ++i) {
                    int x2 = bounds.x + this.wand.xpoints[i];
                    int y2 = bounds.y + this.wand.ypoints[i];
                    if (!this.polygon.contains(x2, y2)) {
                        include = false;
                        break;
                    }
                    if (x1 == x2 && (double)ip.getPixel(x1, y1 - 1) == this.fillColor || y1 == y2 && (double)ip.getPixel(x1 - 1, y1) == this.fillColor) {
                        include = false;
                        break;
                    }
                    x1 = x2;
                    y1 = y2;
                }
            }
        }
        ImageProcessor mask = ip2.getMask();
        if (minCircularity > 0.0 || maxCircularity < 1.0) {
            double circularity;
            double perimeter = ((Roi)roi).getLength();
            double d = circularity = perimeter == 0.0 ? 0.0 : Math.PI * 4 * ((double)stats.pixelCount / (perimeter * perimeter));
            if (circularity > 1.0) {
                circularity = 1.0;
            }
            if (circularity < minCircularity || circularity > maxCircularity) {
                include = false;
            }
        }
        if ((double)stats.pixelCount >= this.minSize && (double)stats.pixelCount <= this.maxSize && include) {
            ++this.particleCount;
            if (this.roiNeedsImage) {
                roi.setImage(imp);
            }
            stats.xstart = x;
            stats.ystart = y;
            this.saveResults(stats, roi);
            if (showChoice != 0) {
                this.drawParticle(this.drawIP, roi, stats, mask);
            }
        }
        if (this.redirectIP != null) {
            ip.setRoi(r);
        }
        ip.fill(mask);
    }

    ImageStatistics getStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        switch (this.imageType2) {
            case 0: {
                return new ByteStatistics(ip, mOptions, cal);
            }
            case 1: {
                return new ShortStatistics(ip, mOptions, cal);
            }
            case 2: {
                return new FloatStatistics(ip, mOptions, cal);
            }
            case 3: {
                return new ColorStatistics(ip, mOptions, cal);
            }
        }
        return null;
    }

    protected void saveResults(ImageStatistics stats, Roi roi) {
        this.analyzer.saveResults(stats, roi);
        if (this.recordStarts) {
            this.rt.addValue("XStart", (double)stats.xstart);
            this.rt.addValue("YStart", (double)stats.ystart);
        }
        if (this.addToManager) {
            if (this.roiManager == null) {
                if (Macro.getOptions() != null && Interpreter.isBatchMode()) {
                    this.roiManager = Interpreter.getBatchModeRoiManager();
                }
                if (this.roiManager == null) {
                    Frame frame = WindowManager.getFrame("ROI Manager");
                    if (frame == null) {
                        IJ.run("ROI Manager...");
                    }
                    if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
                        this.addToManager = false;
                        return;
                    }
                    this.roiManager = (RoiManager)frame;
                }
                if (this.resetCounter) {
                    this.roiManager.runCommand("reset");
                }
            }
            this.roiManager.add(this.imp, roi, this.rt.getCounter());
        }
        if (this.showResults) {
            this.rt.addResults();
        }
    }

    protected void drawParticle(ImageProcessor drawIP, Roi roi, ImageStatistics stats, ImageProcessor mask) {
        switch (showChoice) {
            case 2: {
                this.drawFilledParticle(drawIP, roi, mask);
                break;
            }
            case 1: {
                this.drawOutline(drawIP, roi, this.rt.getCounter());
                break;
            }
            case 3: {
                this.drawEllipse(drawIP, stats, this.rt.getCounter());
                break;
            }
            case 4: {
                this.drawRoiFilledParticle(drawIP, roi, mask, this.rt.getCounter());
                break;
            }
        }
    }

    void drawFilledParticle(ImageProcessor ip, Roi roi, ImageProcessor mask) {
        ip.setRoi(roi.getBounds());
        ip.fill(mask);
    }

    void drawOutline(ImageProcessor ip, Roi roi, int count) {
        Rectangle r = roi.getBounds();
        int nPoints = ((PolygonRoi)roi).getNCoordinates();
        int[] xp = ((PolygonRoi)roi).getXCoordinates();
        int[] yp = ((PolygonRoi)roi).getYCoordinates();
        int x = r.x;
        int y = r.y;
        ip.setValue(0.0);
        ip.moveTo(x + xp[0], y + yp[0]);
        for (int i = 1; i < nPoints; ++i) {
            ip.lineTo(x + xp[i], y + yp[i]);
        }
        ip.lineTo(x + xp[0], y + yp[0]);
        String s = ResultsTable.d2s(count, 0);
        ip.moveTo(r.x + r.width / 2 - ip.getStringWidth(s) / 2, r.y + r.height / 2 + 4);
        ip.setValue(1.0);
        ip.drawString(s);
    }

    void drawEllipse(ImageProcessor ip, ImageStatistics stats, int count) {
        stats.drawEllipse(ip);
    }

    void drawRoiFilledParticle(ImageProcessor ip, Roi roi, ImageProcessor mask, int count) {
        int grayLevel = count < 65535 ? count : 65535;
        ip.setValue(grayLevel);
        ip.setRoi(roi.getBounds());
        ip.fill(mask);
    }

    void showResults() {
        boolean lastSlice;
        int count = this.rt.getCounter();
        if (count == 0) {
            return;
        }
        boolean bl = lastSlice = !this.processStack || this.slice == this.imp.getStackSize();
        if (this.outlines != null && lastSlice) {
            String title;
            String string = title = this.imp != null ? this.imp.getTitle() : "Outlines";
            String prefix = showChoice == 2 ? "Mask of " : (showChoice == 4 ? "Count Masks of " : "Drawing of ");
            this.outlines.update(this.drawIP);
            this.outputImage = new ImagePlus(prefix + title, this.outlines);
            if (!this.hideOutputImage) {
                this.outputImage.show();
            }
        }
        if (this.showResults && !this.processStack) {
            TextPanel tp = IJ.getTextPanel();
            if (this.beginningCount > 0 && tp != null && tp.getLineCount() != count) {
                this.rt.show("Results");
            }
            Analyzer.firstParticle = this.beginningCount;
            Analyzer.lastParticle = Analyzer.getCounter() - 1;
        } else {
            Analyzer.lastParticle = 0;
            Analyzer.firstParticle = 0;
        }
    }

    public ImagePlus getOutputImage() {
        return this.outputImage;
    }

    public void setHideOutputImage(boolean hideOutputImage) {
        this.hideOutputImage = hideOutputImage;
    }

    int getColumnID(String name) {
        int id = this.rt.getFreeColumn(name);
        if (id == -2) {
            id = this.rt.getColumnIndex(name);
        }
        return id;
    }

    void makeCustomLut() {
        IndexColorModel cm = (IndexColorModel)LookUpTable.createGrayscaleColorModel(false);
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        reds[1] = -1;
        greens[1] = 0;
        blues[1] = 0;
        this.customLut = new IndexColorModel(8, 256, reds, greens, blues);
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(OPTIONS, Integer.toString(staticOptions));
    }

    static {
        staticOptions = Prefs.getInt(OPTIONS, 64);
        showStrings = new String[]{"Nothing", "Outlines", "Masks", "Ellipses", "Count Masks"};
        minCircularity = 0.0;
        maxCircularity = 1.0;
    }
}

