/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class StackLabeler
implements ExtendedPlugInFilter,
DialogListener {
    private static final String[] formats = new String[]{"0", "0000", "00:00", "00:00:00", "Text"};
    private static final int NUMBER = 0;
    private static final int ZERO_PADDED_NUMBER = 1;
    private static final int MIN_SEC = 2;
    private static final int HOUR_MIN_SEC = 3;
    private static final int TEXT = 4;
    private static int format = (int)Prefs.get("label.format", 0.0);
    private static final int flags = 63;
    private ImagePlus imp;
    private static int x = 5;
    private static int y = 20;
    private static int fontSize = 18;
    private int maxWidth;
    private Font font;
    private static double start = 0.0;
    private static double interval = 1.0;
    private static String text = "";
    private static int decimalPlaces = 0;
    private int fieldWidth;
    private Color color;
    private int firstSlice;
    private int lastSlice;

    public int setup(String arg, ImagePlus imp) {
        if (imp != null && imp.isHyperStack() && imp.getNFrames() == 1) {
            IJ.error("StackLabeler", "This command does not work with\nsingle time-point hyperstacks.");
            return 4096;
        }
        this.imp = imp;
        return 63;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
            fontSize = (int)(((double)roi.height - 1.10526) / 0.934211);
            if (fontSize < 7) {
                fontSize = 7;
            }
            if (fontSize > 80) {
                fontSize = 80;
            }
        }
        if (IJ.macroRunning()) {
            format = 0;
            decimalPlaces = 0;
            interval = 1.0;
            text = "";
            start = 0.0;
            String options = Macro.getOptions();
            if (options != null) {
                if (options.indexOf("interval=0") != -1 && options.indexOf("format=") == -1) {
                    format = 4;
                }
                if (options.indexOf(" slice=") != -1) {
                    options = options.replaceAll(" slice=", " range=");
                    Macro.setOptions(options);
                }
            }
        }
        if (format < 0 || format > 4) {
            format = 0;
        }
        GenericDialog gd = new GenericDialog("StackLabeler");
        gd.setInsets(2, 5, 0);
        gd.addChoice("Format:", formats, formats[format]);
        gd.addStringField("Starting value:", IJ.d2s(start, decimalPlaces));
        gd.addStringField("Interval:", "" + IJ.d2s(interval, decimalPlaces));
        gd.addNumericField("X location:", x, 0);
        gd.addNumericField("Y location:", y, 0);
        gd.addNumericField("Font size:", fontSize, 0);
        gd.addStringField("Text:", text, 10);
        this.addRange(gd, "Range:", 1, imp.isHyperStack() ? imp.getNFrames() : imp.getStackSize());
        gd.setInsets(10, 20, 0);
        gd.addPreviewCheckbox(pfr);
        gd.addHelp("http://rsb.info.nih.gov/ij/docs/menus/image.html#label");
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        return 63;
    }

    void addRange(GenericDialog gd, String label, int start, int end) {
        gd.addStringField(label, start + "-" + end);
    }

    double[] getRange(GenericDialog gd, int start, int end) {
        String[] range = Tools.split(gd.getNextString(), " -");
        double d1 = Tools.parseDouble(range[0]);
        double d2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
        double[] result = new double[2];
        result[0] = Double.isNaN(d1) ? 1.0 : (double)((int)d1);
        double d = result[1] = Double.isNaN(d2) ? (double)end : (double)((int)d2);
        if (result[0] < (double)start) {
            result[0] = start;
        }
        if (result[1] > (double)end) {
            result[1] = end;
        }
        if (result[0] > result[1]) {
            result[0] = start;
            result[1] = end;
        }
        return result;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        format = gd.getNextChoiceIndex();
        start = Tools.parseDouble(gd.getNextString());
        String str = gd.getNextString();
        interval = Tools.parseDouble(str);
        x = (int)gd.getNextNumber();
        y = (int)gd.getNextNumber();
        fontSize = (int)gd.getNextNumber();
        text = gd.getNextString();
        double[] range = this.getRange(gd, 1, this.imp.getStackSize());
        this.firstSlice = (int)range[0];
        this.lastSlice = (int)range[1];
        int index = str.indexOf(".");
        decimalPlaces = index != -1 ? str.length() - index - 1 : 0;
        if (gd.invalidNumber()) {
            return false;
        }
        this.font = new Font("SansSerif", 0, fontSize);
        if (y < fontSize) {
            y = fontSize + 5;
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(this.font);
        int stackSize = this.imp.getStackSize();
        this.maxWidth = ip.getStringWidth(this.getString(stackSize, interval, format));
        this.fieldWidth = 1;
        if (stackSize >= 10) {
            this.fieldWidth = 2;
        }
        if (stackSize >= 100) {
            this.fieldWidth = 3;
        }
        if (stackSize >= 1000) {
            this.fieldWidth = 4;
        }
        if (stackSize >= 10000) {
            this.fieldWidth = 5;
        }
        Prefs.set("label.format", format);
        return true;
    }

    public void run(ImageProcessor ip) {
        int slice = ip.getSliceNumber();
        if (this.imp.isHyperStack()) {
            slice = (int)((double)(slice - 1) * ((double)this.imp.getNFrames() / (double)this.imp.getStackSize())) + 1;
        }
        if (slice < this.firstSlice || slice > this.lastSlice) {
            return;
        }
        ip.setFont(this.font);
        String s = this.getString(slice - 1, interval, format);
        int textWidth = ip.getStringWidth(s);
        if (this.color == null) {
            this.color = Toolbar.getForegroundColor();
            if ((this.color.getRGB() & 0xFFFFFF) == 0) {
                ip.setRoi(x, y - fontSize, this.maxWidth + textWidth, fontSize);
                double mean = ImageStatistics.getStatistics((ImageProcessor)ip, (int)2, null).mean;
                if (mean < 50.0 && !ip.isInvertedLut()) {
                    this.color = Color.white;
                }
                ip.resetRoi();
            }
        }
        ip.setColor(this.color);
        ip.setAntialiasedText(fontSize >= 18);
        ip.moveTo(x + this.maxWidth - textWidth, y);
        ip.drawString(s);
    }

    String getString(int index, double interval, int format) {
        double time = start + (double)index * interval;
        int itime = (int)Math.floor(time);
        String str = "";
        switch (format) {
            case 0: {
                str = IJ.d2s(time, decimalPlaces) + " " + text;
                break;
            }
            case 1: {
                if (decimalPlaces == 0) {
                    str = this.zeroFill((int)time);
                    break;
                }
                str = IJ.d2s(time, decimalPlaces);
                break;
            }
            case 2: {
                str = this.pad((int)Math.floor(itime / 60 % 60)) + ":" + this.pad(itime % 60);
                break;
            }
            case 3: {
                str = this.pad((int)Math.floor(itime / 3600)) + ":" + this.pad((int)Math.floor(itime / 60 % 60)) + ":" + this.pad(itime % 60);
                break;
            }
            case 4: {
                str = text;
            }
        }
        return str;
    }

    String pad(int n) {
        String str = "" + n;
        if (str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    String zeroFill(int n) {
        String str = "" + n;
        while (str.length() < this.fieldWidth) {
            str = "0" + str;
        }
        return str;
    }

    public void setNPasses(int nPasses) {
    }
}

