/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.frame.ColorCanvas;
import ij.plugin.frame.ColorGenerator;
import ij.plugin.frame.PlugInFrame;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.WindowEvent;

public class ColorPicker
extends PlugInFrame {
    static final String LOC_KEY = "cp.loc";
    static ColorPicker instance;

    public ColorPicker() {
        super("CP");
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        int colorWidth = 22;
        int colorHeight = 16;
        int columns = 5;
        int rows = 20;
        int width = columns * colorWidth;
        int height = rows * colorHeight;
        this.addKeyListener(IJ.getInstance());
        this.setLayout(new BorderLayout());
        ColorGenerator cg = new ColorGenerator(width, height, new int[width * height]);
        cg.drawColors(colorWidth, colorHeight, columns, rows);
        ColorCanvas colorCanvas = new ColorCanvas(width, height, this, cg);
        Panel panel = new Panel();
        panel.add(colorCanvas);
        this.add(panel);
        this.setResizable(false);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        this.show();
    }

    public void windowClosing(WindowEvent e) {
        this.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        IJ.notifyEventListeners(2);
    }
}

