/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.plugin.Colors;
import java.awt.Color;
import java.awt.Font;

public class RoiProperties {
    private Roi roi;
    private String title;
    private boolean showName = true;
    private boolean addToOverlay;

    public RoiProperties(String title, Roi roi) {
        if (roi == null) {
            throw new IllegalArgumentException("ROI is null");
        }
        this.title = title;
        this.showName = title.startsWith("Prop");
        this.addToOverlay = title.equals("Add to Overlay");
        this.roi = roi;
    }

    public boolean showDialog() {
        String fillc;
        String lc;
        String linec;
        double width;
        String nameLabel;
        Color strokeColor = null;
        Color fillColor = null;
        double strokeWidth = 1.0;
        String name = this.roi.getName();
        boolean isRange = name != null && name.startsWith("range: ");
        String string = nameLabel = isRange ? "Range:" : "Name:";
        if (isRange) {
            name = name.substring(7);
        }
        if (name == null) {
            name = "";
        }
        if (!isRange && this.roi instanceof ImageRoi) {
            return this.showImageDialog(name);
        }
        if (this.roi.getStrokeColor() != null) {
            strokeColor = this.roi.getStrokeColor();
        }
        if (strokeColor == null) {
            strokeColor = Roi.getColor();
        }
        if (this.roi.getFillColor() != null) {
            fillColor = this.roi.getFillColor();
        }
        if ((width = (double)this.roi.getStrokeWidth()) > 1.0) {
            strokeWidth = width;
        }
        boolean isText = this.roi instanceof TextRoi;
        boolean isLine = this.roi.isLine();
        if (isText) {
            Font font = ((TextRoi)this.roi).getCurrentFont();
            strokeWidth = font.getSize();
        }
        String string2 = linec = strokeColor != null ? "#" + Integer.toHexString(strokeColor.getRGB()) : "none";
        if (linec.length() == 9 && linec.startsWith("#ff")) {
            linec = "#" + linec.substring(3);
        }
        if ((lc = Colors.hexToColor(linec)) != null) {
            linec = lc;
        }
        String string3 = fillc = fillColor != null ? "#" + Integer.toHexString(fillColor.getRGB()) : "none";
        if (IJ.isMacro()) {
            fillc = "none";
        }
        int digits = (double)((int)strokeWidth) == strokeWidth ? 0 : 1;
        GenericDialog gd = new GenericDialog(this.title);
        if (this.showName) {
            gd.addStringField(nameLabel, name, 15);
        }
        gd.addStringField("Stroke Color: ", linec);
        gd.addNumericField(isText ? "Font Size" : "Width:", strokeWidth, digits);
        if (!isLine) {
            gd.addMessage("");
            gd.addStringField("Fill Color: ", fillc);
        }
        if (this.addToOverlay) {
            gd.addCheckbox("New Overlay", false);
            gd.setInsets(15, 10, 0);
            gd.addMessage("Use the alt-b shortcut\nto skip this dialog.");
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (this.showName) {
            name = gd.getNextString();
            if (!isRange) {
                this.roi.setName(name.length() > 0 ? name : null);
            }
        }
        linec = gd.getNextString();
        strokeWidth = gd.getNextNumber();
        if (!isLine) {
            fillc = gd.getNextString();
        }
        boolean newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        strokeColor = Colors.decode(linec, Roi.getColor());
        fillColor = Colors.decode(fillc, null);
        if (isText) {
            Font font = ((TextRoi)this.roi).getCurrentFont();
            if ((int)strokeWidth != font.getSize()) {
                font = new Font(font.getName(), font.getStyle(), (int)strokeWidth);
                ((TextRoi)this.roi).setCurrentFont(font);
            }
        } else if (this.addToOverlay || strokeWidth > 1.0) {
            this.roi.setStrokeWidth((float)strokeWidth);
        }
        this.roi.setStrokeColor(strokeColor);
        this.roi.setFillColor(fillColor);
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        return true;
    }

    public boolean showImageDialog(String name) {
        boolean newOverlay;
        GenericDialog gd = new GenericDialog(this.title);
        gd.addStringField("Name:", name, 15);
        gd.addNumericField("Opacity (0-100%):", ((ImageRoi)this.roi).getOpacity() * 100.0, 0);
        if (this.addToOverlay) {
            gd.addCheckbox("New Overlay", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        this.roi.setName(name.length() > 0 ? name : null);
        double opacity = gd.getNextNumber() / 100.0;
        ((ImageRoi)this.roi).setOpacity(opacity);
        boolean bl = newOverlay = this.addToOverlay ? gd.getNextBoolean() : false;
        if (newOverlay) {
            this.roi.setName("new-overlay");
        }
        return true;
    }
}

