/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ResultsTable
implements Cloneable {
    public static final int MAX_COLUMNS = 150;
    public static final int COLUMN_NOT_FOUND = -1;
    public static final int COLUMN_IN_USE = -2;
    public static final int TABLE_FULL = -3;
    public static final int AREA = 0;
    public static final int MEAN = 1;
    public static final int STD_DEV = 2;
    public static final int MODE = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int X_CENTROID = 6;
    public static final int Y_CENTROID = 7;
    public static final int X_CENTER_OF_MASS = 8;
    public static final int Y_CENTER_OF_MASS = 9;
    public static final int PERIMETER = 10;
    public static final int ROI_X = 11;
    public static final int ROI_Y = 12;
    public static final int ROI_WIDTH = 13;
    public static final int ROI_HEIGHT = 14;
    public static final int MAJOR = 15;
    public static final int MINOR = 16;
    public static final int ANGLE = 17;
    public static final int CIRCULARITY = 18;
    public static final int FERET = 19;
    public static final int INTEGRATED_DENSITY = 20;
    public static final int MEDIAN = 21;
    public static final int SKEWNESS = 22;
    public static final int KURTOSIS = 23;
    public static final int AREA_FRACTION = 24;
    public static final int RAW_INTEGRATED_DENSITY = 25;
    public static final int CHANNEL = 26;
    public static final int SLICE = 27;
    public static final int FRAME = 28;
    public static final int FERET_X = 29;
    public static final int FERET_Y = 30;
    public static final int FERET_ANGLE = 31;
    public static final int MIN_FERET = 32;
    public static final int ASPECT_RATIO = 33;
    public static final int ROUNDNESS = 34;
    public static final int SOLIDITY = 35;
    public static final int LAST_HEADING = 35;
    private static final String[] defaultHeadings = new String[]{"Area", "Mean", "StdDev", "Mode", "Min", "Max", "X", "Y", "XM", "YM", "Perim.", "BX", "BY", "Width", "Height", "Major", "Minor", "Angle", "Circ.", "Feret", "IntDen", "Median", "Skew", "Kurt", "%Area", "RawIntDen", "Ch", "Slice", "Frame", "FeretX", "FeretY", "FeretAngle", "MinFeret", "AR", "Round", "Solidity"};
    private int maxRows = 100;
    private int maxColumns = 150;
    private String[] headings = new String[this.maxColumns];
    private boolean[] keep = new boolean[this.maxColumns];
    private int counter;
    private double[][] columns = new double[this.maxColumns][];
    private String[] rowLabels;
    private int lastColumn = -1;
    private StringBuffer sb;
    private int precision = 3;
    private String rowLabelHeading = "";
    private char delimiter = (char)9;
    private boolean headingSet;
    private boolean skipRowNumbers;
    private static DecimalFormat[] df;
    private static DecimalFormat[] sf;
    private static DecimalFormatSymbols dfs;

    public static ResultsTable getResultsTable() {
        return Analyzer.getResultsTable();
    }

    public static TextWindow getResultsWindow() {
        Frame f = WindowManager.getFrame("Results");
        if (f == null || !(f instanceof TextWindow)) {
            return null;
        }
        return (TextWindow)f;
    }

    public synchronized void incrementCounter() {
        ++this.counter;
        if (this.counter == this.maxRows) {
            if (this.rowLabels != null) {
                String[] s = new String[this.maxRows * 2];
                System.arraycopy(this.rowLabels, 0, s, 0, this.maxRows);
                this.rowLabels = s;
            }
            for (int i = 0; i <= this.lastColumn; ++i) {
                if (this.columns[i] == null) continue;
                double[] tmp = new double[this.maxRows * 2];
                System.arraycopy(this.columns[i], 0, tmp, 0, this.maxRows);
                this.columns[i] = tmp;
            }
            this.maxRows *= 2;
        }
    }

    public synchronized void addColumns() {
        String[] tmp1 = new String[this.maxColumns * 2];
        System.arraycopy(this.headings, 0, tmp1, 0, this.maxColumns);
        this.headings = tmp1;
        double[][] tmp2 = new double[this.maxColumns * 2][];
        for (int i = 0; i < this.maxColumns; ++i) {
            tmp2[i] = this.columns[i];
        }
        this.columns = tmp2;
        boolean[] tmp3 = new boolean[this.maxColumns * 2];
        System.arraycopy(this.keep, 0, tmp3, 0, this.maxColumns);
        this.keep = tmp3;
        this.maxColumns *= 2;
    }

    public int getCounter() {
        return this.counter;
    }

    public void addValue(int column, double value) {
        if (column >= this.maxColumns) {
            this.addColumns();
        }
        if (column < 0 || column >= this.maxColumns) {
            throw new IllegalArgumentException("Column out of range");
        }
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.columns[column] == null) {
            this.columns[column] = new double[this.maxRows];
            if (this.headings[column] == null) {
                this.headings[column] = "---";
            }
            if (column > this.lastColumn) {
                this.lastColumn = column;
            }
        }
        this.columns[column][this.counter - 1] = value;
    }

    public void addValue(String column, double value) {
        if (column == null) {
            throw new IllegalArgumentException("Column is null");
        }
        int index = this.getColumnIndex(column);
        if (index == -1) {
            index = this.getFreeColumn(column);
        }
        this.addValue(index, value);
        this.keep[index] = true;
    }

    public void addLabel(String label) {
        if (this.rowLabelHeading.equals("")) {
            this.rowLabelHeading = "Label";
        }
        this.addLabel(this.rowLabelHeading, label);
    }

    public void addLabel(String columnHeading, String label) {
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        this.rowLabels[this.counter - 1] = label;
        if (columnHeading != null) {
            this.rowLabelHeading = columnHeading;
        }
    }

    public void setLabel(String label, int row) {
        if (row < 0 || row >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        if (this.rowLabelHeading.equals("")) {
            this.rowLabelHeading = "Label";
        }
        this.rowLabels[row] = label;
    }

    public void disableRowLabels() {
        if (this.rowLabelHeading.equals("Label")) {
            this.rowLabels = null;
        }
    }

    public float[] getColumn(int column) {
        if (column < 0 || column >= this.maxColumns) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        if (this.columns[column] == null) {
            return null;
        }
        float[] data = new float[this.counter];
        for (int i = 0; i < this.counter; ++i) {
            data[i] = (float)this.columns[column][i];
        }
        return data;
    }

    public double[] getColumnAsDoubles(int column) {
        if (column < 0 || column >= this.maxColumns) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        if (this.columns[column] == null) {
            return null;
        }
        double[] data = new double[this.counter];
        for (int i = 0; i < this.counter; ++i) {
            data[i] = this.columns[column][i];
        }
        return data;
    }

    public boolean columnExists(int column) {
        if (column < 0 || column >= this.maxColumns) {
            return false;
        }
        return this.columns[column] != null;
    }

    public int getColumnIndex(String heading) {
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.headings[i] == null) {
                return -1;
            }
            if (!this.headings[i].equals(heading)) continue;
            return i;
        }
        return -1;
    }

    public int getFreeColumn(String heading) {
        for (int i = 0; i < this.headings.length; ++i) {
            if (this.headings[i] == null) {
                this.columns[i] = new double[this.maxRows];
                this.headings[i] = heading;
                if (i > this.lastColumn) {
                    this.lastColumn = i;
                }
                return i;
            }
            if (!this.headings[i].equals(heading)) continue;
            return -2;
        }
        this.addColumns();
        ++this.lastColumn;
        this.columns[this.lastColumn] = new double[this.maxRows];
        this.headings[this.lastColumn] = heading;
        return this.lastColumn;
    }

    public double getValueAsDouble(int column, int row) {
        if (column >= this.maxColumns || row >= this.counter) {
            throw new IllegalArgumentException("Index out of range: " + column + "," + row);
        }
        if (this.columns[column] == null) {
            throw new IllegalArgumentException("Column not defined: " + column);
        }
        return this.columns[column][row];
    }

    public float getValue(int column, int row) {
        return (float)this.getValueAsDouble(column, row);
    }

    public double getValue(String column, int row) {
        if (row < 0 || row >= this.getCounter()) {
            throw new IllegalArgumentException("Row out of range");
        }
        int col = this.getColumnIndex(column);
        if (col == -1) {
            throw new IllegalArgumentException("\"" + column + "\" column not found");
        }
        return this.getValueAsDouble(col, row);
    }

    public String getLabel(int row) {
        if (row < 0 || row >= this.getCounter()) {
            throw new IllegalArgumentException("Row out of range");
        }
        String label = null;
        if (this.rowLabels != null && this.rowLabels[row] != null) {
            label = this.rowLabels[row];
        }
        return label;
    }

    public void setValue(String column, int row, double value) {
        if (column == null) {
            throw new IllegalArgumentException("Column is null");
        }
        int col = this.getColumnIndex(column);
        if (col == -1) {
            col = this.getFreeColumn(column);
        }
        this.setValue(col, row, value);
    }

    public void setValue(int column, int row, double value) {
        if (column >= this.maxColumns) {
            this.addColumns();
        }
        if (column < 0 || column >= this.maxColumns) {
            throw new IllegalArgumentException("Column out of range");
        }
        if (row >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.columns[column] == null) {
            this.columns[column] = new double[this.maxRows];
            if (column > this.lastColumn) {
                this.lastColumn = column;
            }
        }
        this.columns[column][row] = value;
    }

    public String getColumnHeadings() {
        if (this.headingSet && !this.rowLabelHeading.equals("")) {
            for (int i = 0; i <= this.lastColumn; ++i) {
                if (this.columns[i] == null || !this.rowLabelHeading.equals(this.headings[i])) continue;
                this.headings[i] = null;
                this.columns[i] = null;
            }
            this.headingSet = false;
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append(" " + this.delimiter);
        if (this.rowLabels != null) {
            sb.append(this.rowLabelHeading + this.delimiter);
        }
        for (int i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            String heading = this.headings[i];
            if (heading == null) {
                heading = "---";
            }
            sb.append(heading);
            if (i == this.lastColumn) continue;
            sb.append(this.delimiter);
        }
        return new String(sb);
    }

    public String getColumnHeading(int column) {
        if (column < 0 || column >= this.maxColumns) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        return this.headings[column];
    }

    public String getRowAsString(int row) {
        if (row < 0 || row >= this.counter) {
            throw new IllegalArgumentException("Row out of range: " + row);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(200);
        } else {
            this.sb.setLength(0);
        }
        if (!this.skipRowNumbers) {
            this.sb.append(Integer.toString(row + 1));
            this.sb.append(this.delimiter);
        }
        if (this.rowLabels != null) {
            if (this.rowLabels[row] != null) {
                String label = this.rowLabels[row];
                if (this.delimiter == ',') {
                    label = label.replaceAll(",", ";");
                }
                this.sb.append(label);
            }
            this.sb.append(this.delimiter);
        }
        for (int i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            this.sb.append(this.n(this.columns[i][row]));
            if (i == this.lastColumn) continue;
            this.sb.append(this.delimiter);
        }
        return new String(this.sb);
    }

    public void setHeading(int column, String heading) {
        if (column < 0 || column >= this.headings.length) {
            throw new IllegalArgumentException("Column out of range: " + column);
        }
        this.headings[column] = heading;
        if (this.columns[column] == null) {
            this.columns[column] = new double[this.maxRows];
        }
        if (column > this.lastColumn) {
            this.lastColumn = column;
        }
        this.headingSet = true;
    }

    public void setDefaultHeadings() {
        for (int i = 0; i < defaultHeadings.length; ++i) {
            this.headings[i] = defaultHeadings[i];
        }
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    String n(double n) {
        String s = (double)Math.round(n) == n && this.precision >= 0 ? ResultsTable.d2s(n, 0) : ResultsTable.d2s(n, this.precision);
        return s;
    }

    public static String d2s(double n, int decimalPlaces) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return "" + n;
        }
        if (n == 3.4028234663852886E38) {
            return "3.4e38";
        }
        double np = n;
        if (n < 0.0) {
            np = -n;
        }
        if (df == null) {
            dfs = new DecimalFormatSymbols(Locale.US);
            df = new DecimalFormat[10];
            ResultsTable.df[0] = new DecimalFormat("0", dfs);
            ResultsTable.df[1] = new DecimalFormat("0.0", dfs);
            ResultsTable.df[2] = new DecimalFormat("0.00", dfs);
            ResultsTable.df[3] = new DecimalFormat("0.000", dfs);
            ResultsTable.df[4] = new DecimalFormat("0.0000", dfs);
            ResultsTable.df[5] = new DecimalFormat("0.00000", dfs);
            ResultsTable.df[6] = new DecimalFormat("0.000000", dfs);
            ResultsTable.df[7] = new DecimalFormat("0.0000000", dfs);
            ResultsTable.df[8] = new DecimalFormat("0.00000000", dfs);
            ResultsTable.df[9] = new DecimalFormat("0.000000000", dfs);
        }
        if (np < 0.001 && np != 0.0 && np < 1.0 / Math.pow(10.0, decimalPlaces) || np > 9.99999999999E11 || decimalPlaces < 0) {
            if (decimalPlaces < 0) {
                if ((decimalPlaces = -decimalPlaces) > 9) {
                    decimalPlaces = 9;
                }
            } else {
                decimalPlaces = 3;
            }
            if (sf == null) {
                sf = new DecimalFormat[10];
                ResultsTable.sf[1] = new DecimalFormat("0.0E0", dfs);
                ResultsTable.sf[2] = new DecimalFormat("0.00E0", dfs);
                ResultsTable.sf[3] = new DecimalFormat("0.000E0", dfs);
                ResultsTable.sf[4] = new DecimalFormat("0.0000E0", dfs);
                ResultsTable.sf[5] = new DecimalFormat("0.00000E0", dfs);
                ResultsTable.sf[6] = new DecimalFormat("0.000000E0", dfs);
                ResultsTable.sf[7] = new DecimalFormat("0.0000000E0", dfs);
                ResultsTable.sf[8] = new DecimalFormat("0.00000000E0", dfs);
                ResultsTable.sf[9] = new DecimalFormat("0.000000000E0", dfs);
            }
            return sf[decimalPlaces].format(n);
        }
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        return df[decimalPlaces].format(n);
    }

    public synchronized void deleteRow(int row) {
        int i;
        if (this.counter == 0 || row < 0 || row > this.counter - 1) {
            return;
        }
        if (this.rowLabels != null) {
            for (i = row; i < this.counter - 1; ++i) {
                this.rowLabels[i] = this.rowLabels[i + 1];
            }
        }
        for (i = 0; i <= this.lastColumn; ++i) {
            if (this.columns[i] == null) continue;
            for (int j = row; j < this.counter - 1; ++j) {
                this.columns[i][j] = this.columns[i][j + 1];
            }
        }
        --this.counter;
    }

    public synchronized void reset() {
        this.counter = 0;
        this.maxRows = 100;
        for (int i = 0; i < this.maxColumns; ++i) {
            this.columns[i] = null;
            this.headings[i] = null;
            this.keep[i] = false;
        }
        this.lastColumn = -1;
        this.rowLabels = null;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public void addResults() {
        if (this.counter == 1) {
            IJ.setColumnHeadings(this.getColumnHeadings());
        }
        TextPanel textPanel = IJ.getTextPanel();
        String s = this.getRowAsString(this.counter - 1);
        if (textPanel != null) {
            textPanel.appendWithoutUpdate(s);
        } else {
            System.out.println(s);
        }
    }

    public void updateResults() {
        TextPanel textPanel = IJ.getTextPanel();
        if (textPanel != null) {
            textPanel.updateColumnHeadings(this.getColumnHeadings());
            textPanel.updateDisplay();
        }
    }

    public void show(String windowTitle) {
        TextPanel tp;
        if (!windowTitle.equals("Results") && this == Analyzer.getResultsTable()) {
            IJ.log("ResultsTable.show(): the system ResultTable should only be displayed in the \"Results\" window.");
        }
        String tableHeadings = this.getColumnHeadings();
        boolean newWindow = false;
        if (windowTitle.equals("Results")) {
            tp = IJ.getTextPanel();
            if (tp == null) {
                return;
            }
            newWindow = tp.getLineCount() == 0;
            IJ.setColumnHeadings(tableHeadings);
            if (this != Analyzer.getResultsTable()) {
                Analyzer.setResultsTable(this);
            }
            if (this.getCounter() > 0) {
                Analyzer.setUnsavedMeasurements(true);
            }
        } else {
            Frame frame = WindowManager.getFrame(windowTitle);
            TextWindow win = frame != null && frame instanceof TextWindow ? (TextWindow)frame : new TextWindow(windowTitle, "", 400, 300);
            tp = win.getTextPanel();
            tp.setColumnHeadings(tableHeadings);
            newWindow = tp.getLineCount() == 0;
        }
        tp.setResultsTable(this);
        int n = this.getCounter();
        if (n > 0) {
            if (tp.getLineCount() > 0) {
                tp.clear();
            }
            StringBuffer sb = new StringBuffer(n * tableHeadings.length());
            for (int i = 0; i < n; ++i) {
                sb.append(this.getRowAsString(i) + "\n");
            }
            tp.append(new String(sb));
        }
        if (newWindow) {
            tp.scrollToTop();
        }
    }

    public void update(int measurements, ImagePlus imp, Roi roi) {
        if (roi == null && imp != null) {
            roi = imp.getRoi();
        }
        ResultsTable rt2 = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, measurements, rt2);
        ByteProcessor ip = new ByteProcessor(1, 1);
        ByteStatistics stats = new ByteStatistics(ip, measurements, null);
        analyzer.saveResults(stats, roi);
        int last = rt2.getLastColumn();
        while (last + 1 >= this.getMaxColumns()) {
            this.addColumns();
        }
        if (last < this.getLastColumn() && (last = this.getLastColumn()) >= rt2.getMaxColumns()) {
            last = rt2.getMaxColumns() - 1;
        }
        for (int i = 0; i <= last; ++i) {
            if (rt2.getColumn(i) != null && this.columns[i] == null) {
                this.columns[i] = new double[this.maxRows];
                this.headings[i] = rt2.getColumnHeading(i);
                if (i <= this.lastColumn) continue;
                this.lastColumn = i;
                continue;
            }
            if (rt2.getColumn(i) != null || this.columns[i] == null || this.keep[i]) continue;
            this.columns[i] = null;
        }
        if (rt2.getRowLabels() == null) {
            this.rowLabels = null;
        } else if (rt2.getRowLabels() != null && this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
            this.rowLabelHeading = "Label";
        }
        if (this.getCounter() > 0) {
            this.show("Results");
        }
    }

    int getMaxColumns() {
        return this.maxColumns;
    }

    String[] getRowLabels() {
        return this.rowLabels;
    }

    public static ResultsTable open(String path) throws IOException {
        int i;
        boolean allNumericHeadings;
        String lineSeparator = "\n";
        String cellSeparator = ",\t";
        String text = IJ.openAsString(path);
        if (text.startsWith("Error:")) {
            throw new IOException("text.substring(7)");
        }
        String[] lines = Tools.split(text, "\n");
        if (lines.length == 0) {
            throw new IOException("Table is empty or invalid");
        }
        String[] headings = Tools.split(lines[0], ",\t");
        if (headings.length == 1) {
            throw new IOException("This is not a tab or comma delimited text file.");
        }
        int numbersInHeadings = 0;
        for (int i2 = 0; i2 < headings.length; ++i2) {
            if (!headings[i2].equals("NaN") && Double.isNaN(Tools.parseDouble(headings[i2]))) continue;
            ++numbersInHeadings;
        }
        boolean bl = allNumericHeadings = numbersInHeadings == headings.length;
        if (allNumericHeadings) {
            for (int i3 = 0; i3 < headings.length; ++i3) {
                headings[i3] = "C" + (i3 + 1);
            }
        }
        int firstColumn = headings[0].equals(" ") ? 1 : 0;
        for (int i4 = 0; i4 < headings.length; ++i4) {
            headings[i4] = headings[i4].trim();
        }
        int firstRow = allNumericHeadings ? 0 : 1;
        boolean labels = firstColumn == 1 && headings[1].equals("Label");
        int rtn = 0;
        if (!labels && (rtn = ResultsTable.openNonNumericTable(path, lines, firstRow, ",\t")) == 2) {
            return null;
        }
        if (!labels && rtn == 1) {
            labels = true;
        }
        if (lines[0].startsWith("\t")) {
            String[] headings2 = new String[headings.length + 1];
            headings2[0] = " ";
            for (i = 0; i < headings.length; ++i) {
                headings2[i + 1] = headings[i];
            }
            headings = headings2;
            firstColumn = 1;
        }
        ResultsTable rt = new ResultsTable();
        for (i = firstRow; i < lines.length; ++i) {
            rt.incrementCounter();
            String[] items = Tools.split(lines[i], ",\t");
            for (int j = firstColumn; j < items.length; ++j) {
                if (j == 1 && labels) {
                    rt.addLabel(headings[1], items[1]);
                    continue;
                }
                if (j >= headings.length) continue;
                rt.addValue(headings[j], Tools.parseDouble(items[j]));
            }
        }
        return rt;
    }

    static int openNonNumericTable(String path, String[] lines, int firstRow, String cellSeparator) {
        if (lines.length < 2) {
            return 0;
        }
        String[] items = Tools.split(lines[1], cellSeparator);
        int nonNumericCount = 0;
        int nonNumericIndex = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals("NaN") || !Double.isNaN(Tools.parseDouble(items[i]))) continue;
            ++nonNumericCount;
            nonNumericIndex = i;
        }
        boolean csv = path.endsWith(".csv");
        if (nonNumericCount == 0) {
            return 0;
        }
        if (nonNumericCount == 1 && nonNumericIndex == 1) {
            return 1;
        }
        if (csv) {
            lines[0] = lines[0].replaceAll(",", "\t");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < lines.length; ++i) {
            sb.append(lines[i]);
            sb.append("\n");
        }
        String str = sb.toString();
        if (csv) {
            str = str.replaceAll(",", "\t");
        }
        new TextWindow(new File(path).getName(), lines[0], str, 500, 400);
        return 2;
    }

    public void saveAs(String path) throws IOException {
        if (this.getCounter() == 0 && this.lastColumn < 0) {
            return;
        }
        if (path == null || path.equals("")) {
            SaveDialog sd = new SaveDialog("Save Results", "Results", Prefs.get("options.ext", ".xls"));
            String file = sd.getFileName();
            if (file == null) {
                return;
            }
            path = sd.getDirectory() + file;
        }
        this.delimiter = (char)(path.endsWith(".csv") ? 44 : 9);
        PrintWriter pw = null;
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        pw = new PrintWriter(bos);
        if (!Prefs.dontSaveHeaders) {
            String headings = this.getColumnHeadings();
            if (Prefs.dontSaveRowNumbers) {
                headings = headings.substring(2);
            }
            pw.println(headings);
        }
        this.skipRowNumbers = Prefs.dontSaveRowNumbers;
        for (int i = 0; i < this.getCounter(); ++i) {
            pw.println(this.getRowAsString(i));
        }
        this.skipRowNumbers = false;
        pw.close();
        this.delimiter = (char)9;
    }

    public synchronized Object clone() {
        try {
            int i;
            ResultsTable rt2 = (ResultsTable)super.clone();
            rt2.headings = new String[this.headings.length];
            for (i = 0; i <= this.lastColumn; ++i) {
                rt2.headings[i] = this.headings[i];
            }
            rt2.columns = new double[this.columns.length][];
            for (i = 0; i <= this.lastColumn; ++i) {
                if (this.columns[i] == null) continue;
                double[] data = new double[this.maxRows];
                for (int j = 0; j < this.counter; ++j) {
                    data[j] = this.columns[i][j];
                }
                rt2.columns[i] = data;
            }
            if (this.rowLabels != null) {
                rt2.rowLabels = new String[this.rowLabels.length];
                for (i = 0; i < this.counter; ++i) {
                    rt2.rowLabels[i] = this.rowLabels[i];
                }
            }
            return rt2;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "ctr=" + this.counter + ", hdr=" + this.getColumnHeadings();
    }
}

