/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Selection
implements PlugIn,
Measurements {
    private ImagePlus imp;
    private float[] kernel = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private float[] kernel3 = new float[]{1.0f, 1.0f, 1.0f};
    private static String angle = "15";
    private static String enlarge = "15";
    private static String bandSize = "15";
    private static boolean nonScalable;
    private static Color linec;
    private static Color fillc;
    private static int lineWidth;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (arg.equals("add")) {
            this.addToRoiManager(this.imp);
            return;
        }
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("all")) {
            this.imp.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else if (arg.equals("none")) {
            this.imp.killRoi();
        } else if (arg.equals("restore")) {
            this.imp.restoreRoi();
        } else if (arg.equals("spline")) {
            this.fitSpline();
        } else if (arg.equals("circle")) {
            this.fitCircle(this.imp);
        } else if (arg.equals("ellipse")) {
            this.createEllipse(this.imp);
        } else if (arg.equals("hull")) {
            this.convexHull(this.imp);
        } else if (arg.equals("mask")) {
            this.createMask(this.imp);
        } else if (arg.equals("from")) {
            this.createSelectionFromMask(this.imp);
        } else if (arg.equals("inverse")) {
            this.invert(this.imp);
        } else if (arg.equals("tobox")) {
            this.toBoundingBox(this.imp);
        } else if (arg.equals("toarea")) {
            this.lineToArea(this.imp);
        } else if (arg.equals("properties")) {
            this.setProperties("Properties", this.imp.getRoi());
            this.imp.draw();
        } else {
            this.runMacro(arg);
        }
    }

    void runMacro(String arg) {
        String value;
        String options;
        Roi roi = this.imp.getRoi();
        if (IJ.macroRunning() && (options = Macro.getOptions()) != null && (options.indexOf("grid=") != -1 || options.indexOf("interpolat") != -1)) {
            IJ.run("Rotate... ", options);
            return;
        }
        if (roi == null) {
            IJ.error("Rotate>Selection", "This command requires a selection");
            return;
        }
        roi = (Roi)roi.clone();
        if (arg.equals("rotate")) {
            String value2;
            double d = Tools.parseDouble(angle);
            if (Double.isNaN(d)) {
                angle = "15";
            }
            if ((value2 = IJ.runMacroFile("ij.jar:RotateSelection", angle)) != null) {
                angle = value2;
            }
        } else if (arg.equals("enlarge")) {
            value = IJ.runMacroFile("ij.jar:EnlargeSelection", enlarge);
            if (value != null) {
                enlarge = value;
            }
            Roi.previousRoi = roi;
        } else if (arg.equals("band")) {
            value = IJ.runMacroFile("ij.jar:MakeSelectionBand", bandSize);
            if (value != null) {
                bandSize = value;
            }
            Roi.previousRoi = roi;
        }
    }

    void fitCircle(ImagePlus imp) {
        double CenterY;
        double DET;
        double CenterX;
        double radius;
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Fit Circle", "Selection required");
            return;
        }
        if (roi.isArea()) {
            ImageProcessor ip = imp.getProcessor();
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, 33, null);
            double r = Math.sqrt((double)stats.pixelCount / Math.PI);
            imp.killRoi();
            int d = (int)Math.round(2.0 * r);
            IJ.makeOval((int)Math.round(stats.xCentroid - r), (int)Math.round(stats.yCentroid - r), d, d);
            return;
        }
        Polygon poly = roi.getPolygon();
        int n = poly.npoints;
        int[] x = poly.xpoints;
        int[] y = poly.ypoints;
        if (n < 3) {
            IJ.error("Fit Circle", "At least 3 points are required to fit a circle.");
            return;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = 0; i < n; ++i) {
            sumx += (double)poly.xpoints[i];
            sumy += (double)poly.ypoints[i];
        }
        double meanx = sumx / (double)n;
        double meany = sumy / (double)n;
        double[] X = new double[n];
        double[] Y = new double[n];
        double Mxx = 0.0;
        double Myy = 0.0;
        double Mxy = 0.0;
        double Mxz = 0.0;
        double Myz = 0.0;
        double Mzz = 0.0;
        for (int i = 0; i < n; ++i) {
            X[i] = (double)x[i] - meanx;
            Y[i] = (double)y[i] - meany;
            double Zi = X[i] * X[i] + Y[i] * Y[i];
            Mxy += X[i] * Y[i];
            Mxx += X[i] * X[i];
            Myy += Y[i] * Y[i];
            Mxz += X[i] * Zi;
            Myz += Y[i] * Zi;
            Mzz += Zi * Zi;
        }
        double Mz = (Mxx /= (double)n) + (Myy /= (double)n);
        double Cov_xy = Mxx * Myy - (Mxy /= (double)n) * Mxy;
        double Mxz2 = (Mxz /= (double)n) * Mxz;
        double Myz2 = (Myz /= (double)n) * Myz;
        double A2 = 4.0 * Cov_xy - 3.0 * Mz * Mz - (Mzz /= (double)n);
        double A1 = Mzz * Mz + 4.0 * Cov_xy * Mz - Mxz2 - Myz2 - Mz * Mz * Mz;
        double A0 = Mxz2 * Myy + Myz2 * Mxx - Mzz * Cov_xy - 2.0 * Mxz * Myz * Mxy + Mz * Mz * Cov_xy;
        double A22 = A2 + A2;
        double epsilon = 1.0E-12;
        double ynew = 1.0E20;
        int IterMax = 20;
        double xnew = 0.0;
        int iterations = 0;
        for (int iter = 1; iter <= IterMax; ++iter) {
            iterations = iter;
            double yold = ynew;
            ynew = A0 + xnew * (A1 + xnew * (A2 + 4.0 * xnew * xnew));
            if (Math.abs(ynew) > Math.abs(yold)) {
                if (IJ.debugMode) {
                    IJ.log("Fit Circle: wrong direction: |ynew| > |yold|");
                }
                xnew = 0.0;
                break;
            }
            double xold = xnew;
            double Dy = A1 + xnew * (A22 + 16.0 * xnew * xnew);
            if (Math.abs(((xnew = xold - ynew / Dy) - xold) / xnew) < epsilon) break;
            if (iter >= IterMax) {
                if (IJ.debugMode) {
                    IJ.log("Fit Circle: will not converge");
                }
                xnew = 0.0;
            }
            if (!(xnew < 0.0)) continue;
            if (IJ.debugMode) {
                IJ.log("Fit Circle: negative root:  x = " + xnew);
            }
            xnew = 0.0;
        }
        if (IJ.debugMode) {
            IJ.log("Fit Circle: n=" + n + ", xnew=" + IJ.d2s(xnew, 2) + ", iterations=" + iterations);
        }
        if (Double.isNaN(radius = Math.sqrt((CenterX = (Mxz * (Myy - xnew) - Myz * Mxy) / (2.0 * (DET = xnew * xnew - xnew * Mz + Cov_xy))) * CenterX + (CenterY = (Myz * (Mxx - xnew) - Mxz * Mxy) / (2.0 * DET)) * CenterY + Mz + 2.0 * xnew))) {
            IJ.error("Fit Circle", "Points are collinear.");
            return;
        }
        imp.killRoi();
        IJ.makeOval((int)Math.round((CenterX += meanx) - radius), (int)Math.round((CenterY += meany) - radius), (int)Math.round(2.0 * radius), (int)Math.round(2.0 * radius));
    }

    void fitSpline() {
        String options;
        boolean segmentedSelection;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.error("Spline", "Selection required");
            return;
        }
        int type = roi.getType();
        boolean bl = segmentedSelection = type == 2 || type == 6;
        if (!segmentedSelection && type != 3 && type != 4 && type != 7) {
            IJ.error("Spline", "Polygon or polyline selection required");
            return;
        }
        if (roi instanceof EllipseRoi) {
            return;
        }
        PolygonRoi p = (PolygonRoi)roi;
        if (!segmentedSelection) {
            p = this.trimPolygon(p, this.getUncalibratedLength(p));
        }
        if ((options = Macro.getOptions()) != null && options.indexOf("straighten") != -1) {
            p.fitSplineForStraightening();
        } else if (options != null && options.indexOf("remove") != -1) {
            p.removeSplineFit();
        } else {
            p.fitSpline();
        }
        this.imp.draw();
        LineWidthAdjuster.update();
    }

    double getUncalibratedLength(PolygonRoi roi) {
        Calibration cal = this.imp.getCalibration();
        double spw = cal.pixelWidth;
        double sph = cal.pixelHeight;
        cal.pixelWidth = 1.0;
        cal.pixelHeight = 1.0;
        double length = roi.getLength();
        cal.pixelWidth = spw;
        cal.pixelHeight = sph;
        return length;
    }

    PolygonRoi trimPolygon(PolygonRoi roi, double length) {
        int type;
        int[] x = roi.getXCoordinates();
        int[] y = roi.getYCoordinates();
        int n = roi.getNCoordinates();
        x = this.smooth(x, n);
        y = this.smooth(y, n);
        float[] curvature = this.getCurvature(x, y, n);
        Rectangle r = roi.getBounds();
        double threshold = this.rodbard(length);
        double distance = Math.sqrt((x[1] - x[0]) * (x[1] - x[0]) + (y[1] - y[0]) * (y[1] - y[0]));
        x[0] = x[0] + r.x;
        y[0] = y[0] + r.y;
        int i2 = 1;
        int x2 = 0;
        int y2 = 0;
        for (int i = 1; i < n - 1; ++i) {
            int x1 = x[i];
            int y1 = y[i];
            x2 = x[i + 1];
            y2 = y[i + 1];
            distance += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) + 1.0;
            if (!((distance += (double)(curvature[i] * 2.0f)) >= threshold)) continue;
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
            distance = 0.0;
        }
        int n2 = type = roi.getType() == 7 ? 6 : 2;
        if (type == 6 && distance > 0.0) {
            x[i2] = x2 + r.x;
            y[i2] = y2 + r.y;
            ++i2;
        }
        PolygonRoi p = new PolygonRoi(x, y, i2, type);
        this.imp.setRoi(p);
        return p;
    }

    double rodbard(double x) {
        double ex = x == 0.0 ? 5.0 : Math.exp(Math.log(x / 700.0) * 0.88);
        double y = -40.1;
        return (y /= 1.0 + ex) + 44.0;
    }

    int[] smooth(int[] a, int n) {
        FloatProcessor fp = new FloatProcessor(n, 1);
        for (int i = 0; i < n; ++i) {
            fp.putPixelValue(i, 0, a[i]);
        }
        GaussianBlur gb = new GaussianBlur();
        gb.blur1Direction(fp, 2.0, 0.01, true, 0);
        for (int i = 0; i < n; ++i) {
            a[i] = Math.round(fp.getPixelValue(i, 0));
        }
        return a;
    }

    float[] getCurvature(int[] x, int[] y, int n) {
        float[] x2 = new float[n];
        float[] y2 = new float[n];
        for (int i = 0; i < n; ++i) {
            x2[i] = x[i];
            y2[i] = y[i];
        }
        FloatProcessor ipx = new FloatProcessor(n, 1, x2, null);
        FloatProcessor ipy = new FloatProcessor(n, 1, y2, null);
        ((ImageProcessor)ipx).convolve(this.kernel, this.kernel.length, 1);
        ((ImageProcessor)ipy).convolve(this.kernel, this.kernel.length, 1);
        float[] indexes = new float[n];
        float[] curvature = new float[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
            curvature[i] = (float)Math.sqrt((x2[i] - (float)x[i]) * (x2[i] - (float)x[i]) + (y2[i] - (float)y[i]) * (y2[i] - (float)y[i]));
        }
        return curvature;
    }

    void createEllipse(ImagePlus imp) {
        IJ.showStatus("Fitting ellipse");
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Fit Ellipse", "Selection required");
            return;
        }
        if (roi.isLine()) {
            IJ.error("Fit Ellipse", "\"Fit Ellipse\" does not work with line selections");
            return;
        }
        ImageStatistics stats = imp.getStatistics(2080);
        double dx = stats.major * Math.cos(stats.angle / 180.0 * Math.PI) / 2.0;
        double dy = -stats.major * Math.sin(stats.angle / 180.0 * Math.PI) / 2.0;
        double x1 = stats.xCentroid - dx;
        double x2 = stats.xCentroid + dx;
        double y1 = stats.yCentroid - dy;
        double y2 = stats.yCentroid + dy;
        double aspectRatio = stats.minor / stats.major;
        imp.killRoi();
        imp.setRoi(new EllipseRoi(x1, y1, x2, y2, aspectRatio));
    }

    void convexHull(ImagePlus imp) {
        int type;
        Roi roi = imp.getRoi();
        int n = type = roi != null ? roi.getType() : -1;
        if (type != 3 && type != 4 && type != 2 && type != 10) {
            IJ.error("Convex Hull", "Polygonal or point selection required");
            return;
        }
        if (roi instanceof EllipseRoi) {
            return;
        }
        Polygon p = roi.getConvexHull();
        if (p != null) {
            imp.setRoi(new PolygonRoi(p.xpoints, p.ypoints, p.npoints, 2));
        }
    }

    int findFirstPoint(int[] xCoordinates, int[] yCoordinates, int n, ImagePlus imp) {
        int y;
        int smallestY = imp.getHeight();
        for (int i = 0; i < n; ++i) {
            y = yCoordinates[i];
            if (y >= smallestY) continue;
            smallestY = y;
        }
        int smallestX = imp.getWidth();
        int p1 = 0;
        for (int i = 0; i < n; ++i) {
            int x = xCoordinates[i];
            y = yCoordinates[i];
            if (y != smallestY || x >= smallestX) continue;
            smallestX = x;
            p1 = i;
        }
        return p1;
    }

    void createMask(ImagePlus imp) {
        ImageProcessor ip;
        Roi roi = imp.getRoi();
        boolean useInvertingLut = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        if (roi == null || !roi.isArea() && roi.getType() != 10) {
            this.createMaskFromThreshold(imp);
            Prefs.useInvertingLut = useInvertingLut;
            return;
        }
        ImagePlus maskImp = null;
        Frame frame = WindowManager.getFrame("Mask");
        if (frame != null && frame instanceof ImageWindow) {
            maskImp = ((ImageWindow)frame).getImagePlus();
        }
        if (maskImp == null) {
            ip = new ByteProcessor(imp.getWidth(), imp.getHeight());
            if (!Prefs.blackBackground) {
                ip.invertLut();
            }
            maskImp = new ImagePlus("Mask", ip);
            maskImp.show();
        }
        ip = maskImp.getProcessor();
        ip.setRoi(roi);
        ip.setValue(255.0);
        ip.fill(ip.getMask());
        maskImp.updateAndDraw();
        Prefs.useInvertingLut = useInvertingLut;
    }

    void createMaskFromThreshold(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() == -808080.0) {
            IJ.error("Create Mask", "Area selection or thresholded image required");
            return;
        }
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        IJ.run("Duplicate...", "title=mask");
        ImagePlus imp2 = WindowManager.getCurrentImage();
        ImageProcessor ip2 = imp2.getProcessor();
        ip2.setThreshold(t1, t2, 2);
        IJ.run("Convert to Mask");
    }

    void createSelectionFromMask(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() != -808080.0) {
            IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
            return;
        }
        if (!ip.isBinary()) {
            IJ.error("Create Selection", "This command creates a composite selection from\na mask (8-bit binary image with white background)\nor from an image that has been thresholded using\nthe Image>Adjust>Threshold tool. The current\nimage is not a mask and has not been thresholded.");
            return;
        }
        int threshold = ip.isInvertedLut() ? 255 : 0;
        ip.setThreshold(threshold, threshold, 2);
        IJ.runPlugIn("ij.plugin.filter.ThresholdToSelection", "");
    }

    void invert(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isArea()) {
            IJ.error("Inverse", "Area selection required");
            return;
        }
        ShapeRoi s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi s2 = new ShapeRoi(new Roi(0, 0, imp.getWidth(), imp.getHeight()));
        imp.setRoi(s1.xor(s2));
    }

    void lineToArea(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi == null || !roi.isLine()) {
            IJ.error("Line to Area", "Line selection required");
            return;
        }
        if (roi.getType() == 5 && roi.getStrokeWidth() == 1.0f) {
            IJ.error("Line to Area", "Straight line width must be > 1");
            return;
        }
        ByteProcessor ip2 = new ByteProcessor(imp.getWidth(), imp.getHeight());
        ip2.setColor(255);
        if (roi.getType() == 5) {
            ip2.fillPolygon(roi.getPolygon());
        } else {
            roi.drawPixels(ip2);
        }
        ((ImageProcessor)ip2).setThreshold(255.0, 255.0, 2);
        ThresholdToSelection tts = new ThresholdToSelection();
        Roi roi2 = tts.convert(ip2);
        imp.setRoi(roi2);
        Roi.previousRoi = (Roi)roi.clone();
    }

    void toBoundingBox(ImagePlus imp) {
        Roi roi = imp.getRoi();
        Rectangle r = roi.getBounds();
        imp.killRoi();
        imp.setRoi(new Roi(r.x, r.y, r.width, r.height));
    }

    void addToRoiManager(ImagePlus imp) {
        Frame frame;
        if (IJ.macroRunning() && Interpreter.isBatchModeRoiManager()) {
            IJ.error("run(\"Add to Manager\") may not work in batch mode macros");
        }
        if ((frame = WindowManager.getFrame("ROI Manager")) == null) {
            IJ.run("ROI Manager...");
        }
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            return;
        }
        frame = WindowManager.getFrame("ROI Manager");
        if (frame == null || !(frame instanceof RoiManager)) {
            IJ.error("ROI Manager not found");
        }
        RoiManager rm = (RoiManager)frame;
        boolean altDown = IJ.altKeyDown();
        IJ.setKeyUp(-1);
        if (altDown) {
            IJ.setKeyDown(16);
        }
        rm.runCommand("add");
        IJ.setKeyUp(-1);
    }

    boolean setProperties(String title, Roi roi) {
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return false;
        }
        RoiProperties rp = new RoiProperties(title, roi);
        return rp.showDialog();
    }

    static {
        lineWidth = 1;
    }
}

