/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;

public class LineWidthAdjuster
extends PlugInFrame
implements PlugIn,
Runnable,
AdjustmentListener,
TextListener,
ItemListener {
    public static final String LOC_KEY = "line.loc";
    int sliderRange = 300;
    Scrollbar slider;
    int value;
    boolean setText;
    static LineWidthAdjuster instance;
    Thread thread;
    boolean done;
    TextField tf;
    Checkbox checkbox;

    public LineWidthAdjuster() {
        super("Line Width");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.slider = new Scrollbar(0, Line.getWidth(), 1, 1, this.sliderRange + 1);
        this.slider.setFocusable(false);
        Panel panel = new Panel();
        int margin = IJ.isMacOSX() ? 5 : 0;
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(grid);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.ipadx = 100;
        c.insets = new Insets(margin, 15, margin, 5);
        c.anchor = 10;
        grid.setConstraints(this.slider, c);
        panel.add(this.slider);
        c.ipadx = 0;
        c.gridx = 1;
        c.insets = new Insets(margin, 5, margin, 15);
        this.tf = new TextField("" + Line.getWidth(), 4);
        this.tf.addTextListener(this);
        grid.setConstraints(this.tf, c);
        panel.add(this.tf);
        c.gridx = 2;
        c.insets = new Insets(margin, 25, margin, 5);
        this.checkbox = new Checkbox("Spline Fit", this.isSplineFit());
        this.checkbox.addItemListener(this);
        panel.add(this.checkbox);
        this.add((Component)panel, "Center");
        this.slider.addAdjustmentListener(this);
        this.slider.setUnitIncrement(1);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        this.setResizable(false);
        this.show();
        this.thread = new Thread((Runnable)this, "LineWidthAdjuster");
        this.thread.start();
        this.setup();
        this.addKeyListener(IJ.getInstance());
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        this.value = this.slider.getValue();
        this.setText = true;
        this.notify();
    }

    public synchronized void textValueChanged(TextEvent e) {
        int width = (int)Tools.parseDouble(this.tf.getText(), -1.0);
        if (width == -1) {
            return;
        }
        if (width < 0) {
            width = 1;
        }
        if (width != Line.getWidth()) {
            this.slider.setValue(width);
            this.value = width;
            this.notify();
        }
    }

    void setup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            LineWidthAdjuster lineWidthAdjuster = this;
            synchronized (lineWidthAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) {
                    return;
                }
                Line.setWidth(this.value);
                if (this.setText) {
                    this.tf.setText("" + this.value);
                }
                this.setText = false;
                LineWidthAdjuster.updateRoi();
            }
        }
    }

    private static void updateRoi() {
        Roi roi;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) != null && roi.isLine()) {
            roi.updateWideLine(Line.getWidth());
            imp.draw();
            return;
        }
        if (Roi.previousRoi == null) {
            return;
        }
        int id = Roi.previousRoi.getImageID();
        if (id >= 0) {
            return;
        }
        imp = WindowManager.getImage(id);
        if (imp == null) {
            return;
        }
        Roi roi2 = imp.getRoi();
        if (roi2 != null && roi2.isLine()) {
            roi2.updateWideLine(Line.getWidth());
            imp.draw();
        }
    }

    boolean isSplineFit() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            return false;
        }
        if (!(roi instanceof PolygonRoi)) {
            return false;
        }
        return ((PolygonRoi)roi).isSplineFit();
    }

    public void windowClosing(WindowEvent e) {
        this.close();
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        LineWidthAdjuster lineWidthAdjuster = this;
        synchronized (lineWidthAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        this.checkbox.setState(this.isSplineFit());
    }

    public void itemStateChanged(ItemEvent e) {
        boolean selected = e.getStateChange() == 1;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.checkbox.setState(false);
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null || !(roi instanceof PolygonRoi)) {
            this.checkbox.setState(false);
            return;
        }
        int type = roi.getType();
        if (type == 3 || type == 7) {
            this.checkbox.setState(false);
            return;
        }
        PolygonRoi poly = (PolygonRoi)roi;
        boolean splineFit = poly.isSplineFit();
        if (selected && !splineFit) {
            poly.fitSpline();
            imp.draw();
        } else if (!selected && splineFit) {
            poly.removeSplineFit();
            imp.draw();
        }
    }

    public static void update() {
        if (instance == null) {
            return;
        }
        LineWidthAdjuster.instance.checkbox.setState(instance.isSplineFit());
        int sliderWidth = LineWidthAdjuster.instance.slider.getValue();
        int lineWidth = Line.getWidth();
        if (lineWidth != sliderWidth && lineWidth <= 200) {
            LineWidthAdjuster.instance.slider.setValue(lineWidth);
            LineWidthAdjuster.instance.tf.setText("" + lineWidth);
        }
    }
}

