/*
 * Decompiled with CFR 0.152.
 */
package com.cflex.util.lpSolve;

import com.cflex.util.lpSolve.LpModel;
import com.cflex.util.lpSolve.SolverListener;
import com.cflex.util.lpSolve.SolverViewer;
import javax.swing.JOptionPane;

public abstract class Solver {
    public LpModel model;
    public int state = 0;
    public static final int STATE_0_NOT_INITIALIZED = 0;
    public static final int STATE_1_INITIALIZING = 1;
    public static final int STATE_2_INITIALIZED = 2;
    public static final int STATE_3_RUNNING = 3;
    public static final int STATE_4_PAUSED = 4;
    public static final int STATE_5_FINISHED = 5;
    public static final int STATE_6_CANCELED = 6;
    SolverThread currentThread;
    public SolverListener viewer;

    private Solver() {
    }

    public Solver(LpModel lpModel) {
        this.model = lpModel;
        this.state = 0;
        this.currentThread = null;
    }

    public abstract int solve() throws Exception;

    public void getResults() throws Exception {
        this.model.printSolution();
    }

    public void startSolver() {
        if (this.state < 3) {
            this.currentThread = new SolverThread(this);
            this.currentThread.start();
        } else if (this.state == 4) {
            this.pauseSolver();
        }
    }

    public SolverViewer getViewer() throws Exception {
        if (this.viewer == null) {
            this.viewer = new SolverViewer(this);
        }
        return (SolverViewer)this.viewer;
    }

    public void pauseSolver() {
        if (this.state == 4) {
            this.state = 3;
            this.currentThread.notify();
            return;
        }
        if (this.state == 3) {
            this.state = 4;
        } else {
            JOptionPane.showMessageDialog(null, "Trying to pause at a invalid state. Ignored", "Error", 0);
        }
    }

    public void stopSolver() {
        this.state = 6;
    }

    public long getCurrentIteraction() {
        return this.model.iter;
    }

    class SolverThread
    extends Thread {
        Solver solver;

        public SolverThread(Solver solver2) {
            this.solver = solver2;
        }

        public void run() {
            try {
                Solver.this.state = 3;
                Solver.this.viewer.stateChanged();
                int n = this.solver.solve();
                if (Solver.this.state != 6) {
                    if (n == 0) {
                        Solver.this.getResults();
                    }
                    Solver.this.viewer.finished(n);
                    Solver.this.state = 5;
                } else {
                    Solver.this.viewer.finished(-1);
                }
                Solver.this.viewer.stateChanged();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Solver.this.viewer.error(exception);
            }
        }
    }
}

