/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.annotation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.annotation.AbstractAnnotation;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public class DefaultAnnotation
extends AbstractAnnotation {
    private static final long serialVersionUID = -7988756144808776868L;
    private Object matrixAnnotation = null;
    private Map<Integer, Matrix> dimensionMatrices = null;

    public DefaultAnnotation(long[] size) {
        super(size);
    }

    public Matrix getDimensionMatrix(int dimension) {
        Matrix m;
        if (this.dimensionMatrices == null) {
            this.dimensionMatrices = new HashMap<Integer, Matrix>(this.getDimensionCount());
        }
        if ((m = this.dimensionMatrices.get(dimension)) == null) {
            long[] t = Coordinates.copyOf(this.getSize());
            t[dimension] = 1L;
            m = MatrixFactory.sparse(ValueType.OBJECT, t);
            this.dimensionMatrices.put(dimension, m);
        }
        return m;
    }

    public Object getMatrixAnnotation() {
        return this.matrixAnnotation;
    }

    public void setMatrixAnnotation(Object matrixAnnotation) {
        this.matrixAnnotation = matrixAnnotation;
    }

    public static void main(String[] args) throws Exception {
        Matrix m = MatrixFactory.randn(4L, 5L);
        m.setLabel("test");
        m.setColumnLabel(2L, "col2");
        m.setRowLabel(1L, "row1");
        System.out.println(m.plus(Calculation.Ret.LINK, true, -2.0));
    }

    public Annotation clone() {
        DefaultAnnotation a = new DefaultAnnotation(this.getSize());
        a.setMatrixAnnotation(this.getMatrixAnnotation());
        int i = 0;
        while (i < this.getDimensionCount()) {
            a.setDimensionMatrix(i, this.getDimensionMatrix(i).copy());
            ++i;
        }
        return a;
    }

    public void clear() {
        this.matrixAnnotation = null;
        this.dimensionMatrices = null;
    }

    public Object getAxisAnnotation(int dimension, long ... position) {
        Matrix m = this.getDimensionMatrix(dimension);
        long old = position[dimension];
        position[dimension] = 0L;
        Object o = null;
        if (Coordinates.isSmallerThan(position, m.getSize())) {
            o = m.getAsObject(position);
        }
        position[dimension] = old;
        return o;
    }

    public long[] getPositionForLabel(int dimension, Object label) {
        if (label == null) {
            throw new MatrixException("label is null");
        }
        Matrix m = this.getDimensionMatrix(dimension);
        for (long[] c : m.availableCoordinates()) {
            Object o = m.getAsObject(c);
            if (!label.equals(o)) continue;
            return c;
        }
        long[] t = new long[this.getDimensionCount()];
        Arrays.fill(t, -1L);
        return t;
    }

    public void setAxisAnnotation(int dimension, Object label, long ... position) {
        Matrix m = this.getDimensionMatrix(dimension);
        long old = position[dimension];
        position[dimension] = 0L;
        m.setAsObject(label, position);
        position[dimension] = old;
    }

    public void setDimensionMatrix(int dimension, Matrix matrix) {
        if (this.dimensionMatrices == null) {
            this.dimensionMatrices = new HashMap<Integer, Matrix>(this.getDimensionCount());
        }
        if (matrix == null) {
            this.dimensionMatrices.put(dimension, null);
        } else {
            this.dimensionMatrices.put(dimension, matrix);
        }
    }
}

