/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import java.io.File;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.matrix.Matrix2D;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBenchmarkTask {
    private BenchmarkConfig config = null;
    private Class<? extends Matrix> matrixClass = null;
    private String[] sizes = null;
    private long benchmarkSeed = 0L;

    public AbstractBenchmarkTask(long benchmarkSeed, Class<? extends Matrix> matrixClass, String sizes, BenchmarkConfig config) {
        this.matrixClass = matrixClass;
        this.config = config;
        this.sizes = sizes.split(",");
    }

    public BenchmarkConfig getConfig() {
        return this.config;
    }

    public void run() {
        File resultFile = new File(String.valueOf(BenchmarkUtil.getResultDir()) + this.getMatrixLabel() + "/" + this.getTaskName() + ".csv");
        if (resultFile.exists()) {
            System.out.println("old results available, skipping " + this.getTaskName() + " for " + this.getMatrixLabel());
            return;
        }
        Matrix2D result = (Matrix2D)MatrixFactory.zeros(ValueType.STRING, this.config.getRuns(), this.sizes.length);
        result.setLabel(String.valueOf(this.getMatrixLabel()) + "-" + this.getTaskName());
        boolean stopped = false;
        int s = 0;
        while (!stopped && s < this.sizes.length) {
            long[] size = Coordinates.parseString(this.sizes[s]);
            result.setColumnLabel(s, Coordinates.toString('x', size));
            double bestStd = Double.MAX_VALUE;
            int tmpTrialCount = this.config.getDefaultTrialCount();
            DenseDoubleMatrix2D tmpResult = DenseDoubleMatrix2D.factory.dense(this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestResult = DenseDoubleMatrix2D.factory.dense(this.config.getRuns(), 1L);
            int c = 0;
            while (!stopped && c < tmpTrialCount) {
                double t;
                System.out.print(String.valueOf(this.getTaskName()) + " [" + Coordinates.toString('x', size) + "] ");
                System.out.print(String.valueOf(c + 1) + "/" + tmpTrialCount + ": ");
                System.out.flush();
                int i = 0;
                while (!stopped && i < this.config.getBurnInRuns()) {
                    t = this.task(this.matrixClass, this.benchmarkSeed, i, size);
                    if (t == 0.0 || Double.isNaN(t) || t > (double)this.config.getMaxTime()) {
                        stopped = true;
                    }
                    System.out.print("#");
                    System.out.flush();
                    ++i;
                }
                i = 0;
                while (!stopped && i < this.config.getRuns()) {
                    t = this.task(this.matrixClass, this.benchmarkSeed, i, size);
                    if (t == 0.0 || Double.isNaN(t) || t > (double)this.config.getMaxTime()) {
                        stopped = true;
                    }
                    tmpResult.setAsDouble(t, i, 0L);
                    System.out.print(".");
                    System.out.flush();
                    ++i;
                }
                double mean = tmpResult.getMeanValue();
                double std = tmpResult.getStdValue();
                double tempStd = std / mean * 100.0;
                System.out.print(" " + MathUtil.round(mean, 3) + "+-" + MathUtil.round(std, 3) + "ms (+-" + MathUtil.round(tempStd, 1) + "%)");
                if (tempStd > this.config.getMaxStd()) {
                    System.out.print(" standard deviation too large, result discarded");
                    if (tmpTrialCount < this.config.getMaxTrialCount()) {
                        ++tmpTrialCount;
                    }
                }
                if (tempStd < bestStd) {
                    bestStd = tempStd;
                    int i2 = 0;
                    while (i2 < this.config.getRuns()) {
                        bestResult.setDouble(tmpResult.getDouble(i2, 0), i2, 0);
                        ++i2;
                    }
                }
                System.out.println();
                ++c;
            }
            int i = 0;
            while (!stopped && i < this.config.getRuns()) {
                result.setAsDouble(bestResult.getDouble(i, 0), i, s);
                ++i;
            }
            ++s;
        }
        Matrix temp = MatrixFactory.vertCat(result.getAnnotation().getDimensionMatrix(0), result);
        try {
            temp.exportToFile(FileFormat.CSV, resultFile, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract double task(Class<? extends Matrix> var1, long var2, int var4, long[] var5);

    public abstract String getTaskName();

    public String getMatrixLabel() {
        return this.matrixClass.getSimpleName();
    }
}

