/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigintegermatrix.impl;

import java.math.BigInteger;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigintegermatrix.stub.AbstractDenseBigIntegerMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class DefaultDenseBigIntegerMatrix2D
extends AbstractDenseBigIntegerMatrix2D {
    private static final long serialVersionUID = 443424906231157395L;
    private BigInteger[] values = null;
    private long[] size = null;
    private int rows = 0;
    private int cols = 0;

    public DefaultDenseBigIntegerMatrix2D(Matrix m) throws MatrixException {
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        this.size = new long[]{this.rows, this.cols};
        if (m instanceof DefaultDenseBigIntegerMatrix2D) {
            BigInteger[] v = ((DefaultDenseBigIntegerMatrix2D)m).values;
            this.values = new BigInteger[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new BigInteger[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setBigInteger(m.getAsBigInteger(c), c);
            }
        }
    }

    public DefaultDenseBigIntegerMatrix2D(long ... size) {
        this.rows = (int)size[0];
        this.cols = (int)size[1];
        this.size = new long[]{this.rows, this.cols};
        this.values = new BigInteger[this.rows * this.cols];
    }

    public DefaultDenseBigIntegerMatrix2D(BigInteger[] v, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.size = new long[]{rows, cols};
        this.values = v;
    }

    public long[] getSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.rows;
    }

    public long getColumnCount() {
        return this.cols;
    }

    public BigInteger getBigInteger(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setBigInteger(BigInteger value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public BigInteger getBigInteger(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setBigInteger(BigInteger value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }
}

