/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.booleanmatrix.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.booleanmatrix.calculation.AbstractBooleanCalculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Xor
extends AbstractBooleanCalculation {
    private static final long serialVersionUID = -6373580510308593463L;

    public Xor(Matrix m1, Matrix m2) {
        super(m1, m2);
        if (m2.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[1] = MatrixFactory.fill(m2.getAsBoolean(0L, 0L), m1.getSize());
        } else if (m1.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[0] = MatrixFactory.fill(m1.getAsBoolean(0L, 0L), m2.getSize());
        }
    }

    public Xor(Matrix m1, boolean v2) throws MatrixException {
        this(m1, MatrixFactory.fill(v2, m1.getSize()));
    }

    public Xor(boolean v1, Matrix m2) throws MatrixException {
        this(MatrixFactory.fill(v1, m2.getSize()), m2);
    }

    public boolean getBoolean(long ... coordinates) throws MatrixException {
        return MathUtil.xor(this.getSource().getAsBoolean(coordinates), this.getSources()[1].getAsBoolean(coordinates));
    }
}

