/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ujmp.core.exceptions.MatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMap<K, V>
extends java.util.AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -6429342188863787235L;

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K k : map.keySet()) {
            this.put(k, map.get(k));
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (K key : this.keySet()) {
            if (!value.equals(this.get(key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<K> it;
                    {
                        this.it = AbstractMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public V next() {
                        return AbstractMap.this.get(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new MatrixException("not implemented");
                    }
                };
            }

            @Override
            public int size() {
                return this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<K> it;
                    {
                        this.it = AbstractMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Object k = this.it.next();
                        final Object v = AbstractMap.this.get(k);
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return k;
                            }

                            @Override
                            public V getValue() {
                                return v;
                            }

                            @Override
                            public V setValue(V value) {
                                throw new MatrixException("not implemented");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new MatrixException("not implemented");
                    }
                };
            }

            @Override
            public int size() {
                return this.size();
            }
        };
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            while (true) {
                Object k = s.readObject();
                Object v = s.readObject();
                this.put(k, v);
            }
        }
        catch (OptionalDataException e) {
            return;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        for (K k : this.keySet()) {
            V v = this.get(k);
            s.writeObject(k);
            s.writeObject(v);
        }
    }

    @Override
    public abstract void clear();

    @Override
    public abstract V get(Object var1);

    @Override
    public abstract Set<K> keySet();

    @Override
    public abstract V put(K var1, V var2);

    @Override
    public abstract V remove(Object var1);

    @Override
    public abstract int size();
}

