/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.datematrix.calculation;

import java.util.Date;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.datematrix.DateMatrix;
import org.ujmp.core.datematrix.calculation.DateCalculation;
import org.ujmp.core.datematrix.impl.DateCalculationMatrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class AbstractDateCalculation
extends AbstractCalculation
implements DateCalculation {
    private static final long serialVersionUID = -7928696345352218988L;

    public AbstractDateCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractDateCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final DateMatrix calcNew() throws MatrixException {
        DateMatrix result = (DateMatrix)MatrixFactory.zeros(ValueType.DATE, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsDate(this.getDate(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final DateMatrix calcLink() throws MatrixException {
        return new DateCalculationMatrix(this);
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsDate(this.getDate(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setDate(Date value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.DATE;
    }
}

