/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.datematrix.impl;

import java.util.Date;
import org.ujmp.core.Matrix;
import org.ujmp.core.datematrix.stub.AbstractDenseDateMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasDateArray;

public class DefaultDenseDateMatrix2D
extends AbstractDenseDateMatrix2D
implements HasDateArray {
    private static final long serialVersionUID = -3145074963888564555L;
    private Date[] values = null;
    private long[] size = null;
    private int rows = 0;
    private int cols = 0;

    public DefaultDenseDateMatrix2D(Matrix m) throws MatrixException {
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        this.size = new long[]{this.rows, this.cols};
        if (m instanceof DefaultDenseDateMatrix2D) {
            Date[] v = ((DefaultDenseDateMatrix2D)m).values;
            this.values = new Date[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new Date[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setDate(m.getAsDate(c), c);
            }
        }
    }

    public DefaultDenseDateMatrix2D(long ... size) {
        this.rows = (int)size[0];
        this.cols = (int)size[1];
        this.size = new long[]{this.rows, this.cols};
        this.values = new Date[this.rows * this.cols];
    }

    public DefaultDenseDateMatrix2D(Date[] v, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.size = new long[]{rows, cols};
        this.values = v;
    }

    public long[] getSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.rows;
    }

    public long getColumnCount() {
        return this.cols;
    }

    public Date getDate(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setDate(Date value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public Date getDate(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setDate(Date value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix copy() throws MatrixException {
        Date[] result = new Date[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseDateMatrix2D m = new DefaultDenseDateMatrix2D(result, this.rows, this.cols);
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        Date[] result = new Date[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseDateMatrix2D(result, this.cols, this.rows);
    }

    public Date[] getDateArray() {
        return this.values;
    }
}

