/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.basic;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class Plus
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -2670849261944345597L;
    private boolean ignoreNaN = false;

    public Plus(boolean ignoreNaN, Matrix m1, Matrix m2) {
        super(m1, m2);
        this.ignoreNaN = ignoreNaN;
        if (m2.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[1] = MatrixFactory.fill(m2.getAsDouble(0L, 0L), m1.getSize());
        } else if (m1.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[0] = MatrixFactory.fill(m1.getAsDouble(0L, 0L), m2.getSize());
        }
    }

    public Plus(Matrix m1, Matrix m2) {
        this(true, m1, m2);
    }

    public Plus(boolean ignoreNaN, Matrix m1, double v2) throws MatrixException {
        this(m1, MatrixFactory.fill(v2, m1.getSize()));
    }

    public Plus() {
        super(new Matrix[0]);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return this.ignoreNaN ? MathUtil.ignoreNaN(this.getSources()[0].getAsDouble(coordinates)) + MathUtil.ignoreNaN(this.getSources()[1].getAsDouble(coordinates)) : this.getSources()[0].getAsDouble(coordinates) + this.getSources()[1].getAsDouble(coordinates);
    }
}

