/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.basic;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Power
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -6766560469728046231L;

    public Power(Matrix m1, Matrix m2) {
        super(m1, m2);
        if (m2.isScalar() && !Coordinates.equals(m1.getSize(), m2.getSize())) {
            this.getSources()[1] = MatrixFactory.fill(m2.getAsDouble(0L, 0L), m1.getSize());
        }
    }

    public Power(Matrix m1, double v2) throws MatrixException {
        this(m1, MatrixFactory.fill(v2, m1.getSize()));
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return Math.pow(this.getSource().getAsDouble(coordinates), this.getSources()[1].getAsDouble(coordinates));
    }

    public static Matrix calc(Matrix source, Matrix power) throws MatrixException {
        if (power.isScalar() && !Coordinates.equals(source.getSize(), power.getSize())) {
            power = MatrixFactory.fill(power.getAsDouble(0L, 0L), source.getSize());
        }
        Matrix ret = MatrixFactory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.pow(source.getAsDouble(c), power.getAsDouble(c)), c);
        }
        return ret;
    }

    public static Matrix calc(Matrix source, double power) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.pow(source.getAsDouble(c), power), c);
        }
        return ret;
    }
}

