/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.rounding;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Round
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -5038322249059783563L;

    public Round(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return Math.round(this.getSource().getAsDouble(coordinates));
    }

    public static Matrix calcNew(Matrix source) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.round(source.getAsDouble(c)), c);
        }
        return ret;
    }
}

